/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class ScrolledViewport {
    private final JScrollPane scrollPane;
    private final JComponent view;
    private final Border originalBorder;

    public ScrolledViewport(JComponent jComponent) {
        this.view = jComponent;
        this.originalBorder = jComponent.getBorder();
        this.scrollPane = new JScrollPane(jComponent);
        ScrollBarVisibilityChangeListener scrollBarVisibilityChangeListener = new ScrollBarVisibilityChangeListener();
        this.scrollPane.getHorizontalScrollBar().addComponentListener(scrollBarVisibilityChangeListener);
        this.scrollPane.getVerticalScrollBar().addComponentListener(scrollBarVisibilityChangeListener);
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void setScrollingSpeed(int n) {
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(n);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(n);
    }

    private class ScrollBarVisibilityChangeListener
    extends ComponentAdapter {
        private ScrollBarVisibilityChangeListener() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            this.updateBorder();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.updateBorder();
        }

        private void updateBorder() {
            if (ScrolledViewport.this.scrollPane.getHorizontalScrollBar().isVisible() || ScrolledViewport.this.scrollPane.getVerticalScrollBar().isVisible()) {
                ScrolledViewport.this.view.setBorder(ScrolledViewport.this.originalBorder);
            } else {
                ScrolledViewport.this.view.setBorder(null);
            }
        }
    }
}

