/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.chattext;

import games.stendhal.client.scripting.ChatLineParser;
import games.stendhal.client.sprite.EmojiStore;
import games.stendhal.client.sprite.ImageSprite;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CharacterMap
extends JButton {
    private static final EmojiStore emojis = EmojiStore.get();

    public CharacterMap() {
        Font font = this.getFont();
        this.setFont(new Font("Noto Emoji", font.getStyle(), font.getSize() + 2));
        this.setFocusable(false);
        this.setToolTipText("Emojis");
        ImageSprite imageSprite = (ImageSprite)emojis.create(":smile:");
        if (imageSprite != null) {
            this.setIcon(new ImageIcon(imageSprite.getImage()));
        } else {
            this.setText("\u263a");
        }
        final JPopupMenu jPopupMenu = new JPopupMenu();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jPopupMenu.show(CharacterMap.this, CharacterMap.this.getWidth() - jPopupMenu.getPreferredSize().width, CharacterMap.this.getHeight());
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof EmojiButton) {
                    ChatLineParser.parseAndHandle(((EmojiButton)object).getEmojiText());
                }
            }
        };
        this.fillMenu(jPopupMenu, actionListener);
    }

    private void fillMenu(JComponent jComponent, ActionListener actionListener) {
        jComponent.setLayout(new GridLayout(0, 13));
        Insets insets = new Insets(1, 1, 1, 1);
        this.setMargin(insets);
        for (String string : emojis.getEmojiList()) {
            string = ":" + string + ":";
            ImageSprite imageSprite = (ImageSprite)emojis.create(string);
            if (imageSprite == null) continue;
            EmojiButton emojiButton = new EmojiButton(imageSprite, string);
            emojiButton.setMargin(insets);
            emojiButton.addActionListener(actionListener);
            emojiButton.setBorder(null);
            jComponent.add(emojiButton);
        }
    }

    private class EmojiButton
    extends JMenuItem {
        private final String emojiText;

        public EmojiButton(ImageSprite imageSprite, String string) {
            super(new ImageIcon(imageSprite.getImage()));
            this.emojiText = string;
            this.setIconTextGap(0);
            this.setToolTipText(string);
        }

        public String getEmojiText() {
            return this.emojiText;
        }
    }
}

