/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.imageviewer;

import games.stendhal.client.GameScreen;
import games.stendhal.client.gui.ScrolledViewport;
import games.stendhal.client.gui.imageviewer.ImageViewWindow;
import games.stendhal.client.gui.imageviewer.ViewPanel;
import games.stendhal.client.gui.textformat.HTMLBuilder;
import games.stendhal.client.gui.textformat.StringFormatter;
import games.stendhal.client.gui.textformat.TextAttributeSet;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.TextAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import marauroa.common.game.RPEvent;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;

public final class ItemListImageViewerEvent
extends ViewPanel {
    private static final int PAD = 5;
    private static final long serialVersionUID = -6114543463410539585L;
    private final StringFormatter<Map<TextAttribute, Object>, TextAttributeSet> formatter = new StringFormatter();
    private final TextAttributeSet defaultAttrs = new TextAttributeSet();
    private final RPEvent event;

    public ItemListImageViewerEvent(RPEvent rPEvent) {
        this.event = rPEvent;
        TextAttributeSet textAttributeSet = new TextAttributeSet();
        textAttributeSet.setAttribute(TextAttribute.UNDERLINE, "u");
        this.formatter.addStyle(Character.valueOf('\u00a7'), textAttributeSet);
    }

    public void view() {
        new ImageViewWindow(this.event.get("title"), this);
    }

    @Override
    public void prepareView(Dimension dimension) {
        Object object;
        JComponent jComponent;
        Dimension dimension2 = GameScreen.get().getSize();
        int n = dimension2.width - 80;
        if (this.event.has("caption")) {
            jComponent = new JLabel("<html><div width=" + (n - 10) + ">" + this.event.get("caption") + "</div></html>");
            jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)jComponent, "North");
        }
        jComponent = this.createTable(n);
        jComponent.setEnabled(false);
        ((JTable)jComponent).setFillsViewportHeight(true);
        ((JTable)jComponent).setAutoResizeMode(3);
        TableColumn tableColumn = ((JTable)jComponent).getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new SpriteCellRenderer());
        tableColumn = ((JTable)jComponent).getColumnModel().getColumn(1);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn = ((JTable)jComponent).getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new DescriptionCellRenderer());
        HeaderRenderer headerRenderer = new HeaderRenderer();
        Enumeration<TableColumn> enumeration = ((JTable)jComponent).getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ((TableColumn)object).setHeaderRenderer(headerRenderer);
        }
        this.adjustColumnWidths((JTable)jComponent);
        this.adjustRowHeights((JTable)jComponent);
        object = new ScrolledViewport(jComponent);
        ((ScrolledViewport)object).getComponent().setPreferredSize(new Dimension(n, Math.min(dimension2.height - 100, jComponent.getPreferredSize().height + headerRenderer.getPreferredSize().height + 20)));
        ((ScrolledViewport)object).getComponent().setBackground(jComponent.getBackground());
        this.add((Component)((ScrolledViewport)object).getComponent(), "Center");
        this.setVisible(true);
    }

    private void adjustColumnWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n = tableColumn.getWidth();
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                Component component = jTable.prepareRenderer(jTable.getCellRenderer(j, i), j, i);
                n = Math.max(n, component.getPreferredSize().width);
            }
            tableColumn.setPreferredWidth(n);
        }
    }

    private void adjustRowHeights(JTable jTable) {
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n = jTable.getRowHeight();
            for (int j = 0; j < jTable.getColumnCount(); ++j) {
                Component component = jTable.prepareRenderer(jTable.getCellRenderer(i, j), i, j);
                n = Math.max(n, component.getPreferredSize().height);
            }
            jTable.setRowHeight(i, n);
        }
    }

    private JTable createTable(int n) {
        Object[] objectArray = new String[]{"Item", "Price", "Description"};
        Object[][] objectArray2 = new Object[this.event.getSlot("content").size()][];
        RPSlot rPSlot = this.event.getSlot("content");
        int n2 = 0;
        for (RPObject rPObject : rPSlot) {
            objectArray2[n2] = this.createDataRow(rPObject, n);
            ++n2;
        }
        return new JTable(objectArray2, objectArray);
    }

    private Object[] createDataRow(RPObject rPObject, int n) {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.getItemSprite(rPObject);
        objectArray[1] = this.getFormattedPrice(rPObject);
        StringBuilder stringBuilder = new StringBuilder("<html><div width=");
        stringBuilder.append(n - 170);
        stringBuilder.append('>');
        String string = rPObject.get("description_info");
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        this.formatter.format(string, this.defaultAttrs, hTMLBuilder);
        stringBuilder.append(hTMLBuilder.toHTML());
        stringBuilder.append("</div></html>");
        objectArray[2] = stringBuilder.toString();
        return objectArray;
    }

    private String getFormattedPrice(RPObject rPObject) {
        String string = "";
        if (rPObject.has("price")) {
            int n = rPObject.getInt("price");
            string = "<html><span style=\"color: ";
            string = n < 0 ? string + "#FFFFFF\">" : string + "#00FF00\">";
            string = string + Math.abs(n) + "</span></html>";
        }
        return string;
    }

    private Sprite getItemSprite(RPObject rPObject) {
        String string3;
        List<String> list = Arrays.asList("arctic_char", "clown-fish", "cod", "mackerel", "perch", "roach", "surgeonfish", "trout", "red-lionfish", "smoked cod", "smoked trout");
        String string2 = rPObject.get("subclass");
        for (String string3 : list) {
            if (!string3.equals(string2)) continue;
            string2 = "unknown_fish";
        }
        String string4 = rPObject.get("class") + "/" + string2;
        string3 = "/data/sprites/items/" + (String)string4 + ".png";
        Sprite sprite = SpriteStore.get().getSprite(string3);
        if (sprite.getWidth() > sprite.getHeight()) {
            sprite = SpriteStore.get().getAnimatedSprite(sprite, 100);
        }
        return sprite;
    }

    private static class SpriteCellRenderer
    extends JComponent
    implements TableCellRenderer {
        private Sprite sprite;

        private SpriteCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = jTable.getValueAt(n, n2);
            this.sprite = object2 instanceof Sprite ? (Sprite)object2 : null;
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            if (this.sprite != null) {
                dimension.width = this.sprite.getWidth() + 10;
                dimension.height = this.sprite.getHeight() + 10;
            }
            return dimension;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.sprite != null) {
                this.sprite.draw(graphics, (this.getWidth() - this.sprite.getWidth()) / 2, (this.getHeight() - this.sprite.getHeight()) / 2);
            }
        }
    }

    private static class DescriptionCellRenderer
    extends DefaultTableCellRenderer {
        private final Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);

        private DescriptionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setBorder(this.border);
            return this;
        }
    }

    public static class HeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        private final JLabel header = new JLabel();

        public HeaderRenderer() {
            this.add(this.header);
            this.header.setBorder(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.header.setText(object.toString());
            return this;
        }
    }
}

