/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d;

import games.stendhal.client.GameScreen;
import games.stendhal.client.GameScreenSpriteHelper;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.sprite.Sprite;
import java.awt.Graphics;
import java.awt.Rectangle;

public class RemovableSprite
implements Comparable<RemovableSprite> {
    public static final long STANDARD_PERSISTENCE_TIME = 5000L;
    private int x;
    private int y;
    private int offsetY = 0;
    private Entity owner;
    private final Sprite sprite;
    private long removeTime;
    private int priority;

    public RemovableSprite(Sprite sprite, int n, int n2, long l) {
        this.sprite = sprite;
        this.x = n;
        this.y = n2;
        this.setPersistTime(l);
    }

    public RemovableSprite(Sprite sprite, Entity entity, long l) {
        this.sprite = sprite;
        this.owner = entity;
        int n = this.getAttachedY();
        this.offsetY = GameScreenSpriteHelper.findFreeTextBoxPosition(sprite, this.getAttachedX(), n) - n;
        this.setPersistTime(l);
    }

    private void setPersistTime(long l) {
        this.removeTime = l == 0L ? System.currentTimeMillis() + 5000L : System.currentTimeMillis() + l;
    }

    public void draw(Graphics graphics) {
        if (this.owner != null) {
            this.drawAttached(graphics);
            return;
        }
        this.sprite.draw(graphics, this.x, this.y);
    }

    private void drawAttached(Graphics graphics) {
        int n = this.getAttachedX();
        int n2 = this.getAttachedY();
        this.sprite.draw(graphics, n, n2);
    }

    public void drawEmoji(Graphics graphics) {
        int n;
        int n2;
        int n3 = GameScreenSpriteHelper.getScreenViewX();
        int n4 = GameScreenSpriteHelper.getScreenViewY();
        if (GameScreen.get().isScaled()) {
            n2 = GameScreenSpriteHelper.convertWorldXToScaledScreen(this.owner.getX());
            n = GameScreenSpriteHelper.convertWorldYToScaledScreen(this.owner.getY());
        } else {
            n2 = GameScreenSpriteHelper.convertWorldToPixelUnits(this.owner.getX());
            n = GameScreenSpriteHelper.convertWorldToPixelUnits(this.owner.getY());
        }
        this.sprite.draw(graphics, n2 - n3 - 16, n - n4 - 32);
    }

    private int getAttachedX() {
        int n = GameScreenSpriteHelper.convertWorldXToScaledScreen(this.owner.getX() + this.owner.getWidth());
        n = GameScreenSpriteHelper.keepSpriteOnMapX(this.sprite, n);
        return n;
    }

    private int getAttachedY() {
        int n = GameScreenSpriteHelper.convertWorldYToScaledScreen(this.owner.getY());
        n -= this.sprite.getHeight();
        n = GameScreenSpriteHelper.keepSpriteOnMapY(this.sprite, n);
        return n + this.offsetY;
    }

    public Rectangle getArea() {
        if (this.owner != null) {
            int n = this.getAttachedX();
            int n2 = this.getAttachedY();
            return new Rectangle(n, n2, this.sprite.getWidth(), this.sprite.getHeight());
        }
        return new Rectangle(this.x, this.y, this.sprite.getWidth(), this.sprite.getHeight());
    }

    public int getX() {
        if (this.owner != null) {
            return this.getAttachedX();
        }
        return this.x;
    }

    public int getY() {
        if (this.owner != null) {
            return this.getAttachedY();
        }
        return this.y;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public boolean shouldBeRemoved() {
        return System.currentTimeMillis() >= this.removeTime;
    }

    @Override
    public int compareTo(RemovableSprite removableSprite) {
        return this.priority - removableSprite.priority;
    }
}

