/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.Blood;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2d.entity.StateEntity2DView;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.util.Map;

class Blood2DView
extends StateEntity2DView<IEntity> {
    Blood2DView() {
    }

    @Override
    protected void buildSprites(IEntity iEntity, Map<Object, Sprite> map) {
        SpriteStore spriteStore = SpriteStore.get();
        ZoneInfo zoneInfo = ZoneInfo.get();
        Sprite sprite = spriteStore.getModifiedSprite("data/sprites/combat/blood_" + iEntity.getEntityClass() + ".png", zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        int n = sprite.getHeight();
        int n2 = 0;
        for (int i = 0; i < n; i += 32) {
            map.put(n2++, spriteStore.getTile(sprite, 0, i, 32, 32));
        }
    }

    @Override
    protected Object getState(IEntity iEntity) {
        return ((Blood)iEntity).getAmount();
    }

    @Override
    public int getZIndex() {
        return 2000;
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == Blood.PROP_AMOUNT) {
            this.proceedChangedState(this.entity);
        }
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.WALK;
    }
}

