/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.ActiveEntity;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.entity.StatusID;
import games.stendhal.client.entity.TextIndicator;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.j2d.entity.ActiveEntity2DView;
import games.stendhal.client.gui.j2d.entity.HealthBar;
import games.stendhal.client.gui.j2d.entity.helpers.AttackPainter;
import games.stendhal.client.gui.j2d.entity.helpers.HorizontalAlignment;
import games.stendhal.client.gui.j2d.entity.helpers.VerticalAlignment;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.AnimatedSprite;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.sprite.TextSprite;
import games.stendhal.common.Direction;
import games.stendhal.common.constants.Nature;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;

abstract class RPEntity2DView<T extends RPEntity>
extends ActiveEntity2DView<T> {
    private static final int ICON_OFFSET = 8;
    private static final int HEALTH_BAR_HEIGHT = 4;
    private static final Sprite blockedSprite;
    private static final Sprite hitSprite;
    private static final Sprite missedSprite;
    private static final Sprite healerSprite;
    private static final Sprite merchantSprite;
    private static final Sprite producerSprite;
    private static final Sprite chokingSprite;
    private static final Sprite confusedSprite;
    private static final Sprite eatingSprite;
    private static final Sprite poisonedSprite;
    private static final Sprite shockedSprite;
    private static final Sprite heavySprite;
    private static final Color RING_COLOR_RED;
    private static final Color RING_COLOR_DARK_RED;
    private static final Color RING_COLOR_ORANGE;
    private static final double SQRT2 = 1.414213562;
    private Map<TextIndicator, Sprite> floaters = new HashMap<TextIndicator, Sprite>();
    private boolean titleChanged;
    private boolean showTitle;
    private boolean showHP;
    protected int titleDrawYOffset = 0;
    private Sprite titleSprite;
    protected int height;
    protected int width;
    private final List<AbstractStatusIconManager> iconManagers = new ArrayList<AbstractStatusIconManager>();
    private HealthBar healthBar;
    private int statusBarYOffset;
    private volatile boolean iconsChanged;
    private volatile boolean isAttacking;
    private boolean rangedAttack;
    private AttackPainter attackPainter;

    public RPEntity2DView() {
        this.addIconManager(new StatusIconManager(RPEntity.PROP_HEALER, healerSprite, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, StatusID.HEALER));
        this.addIconManager(new StatusIconManager(RPEntity.PROP_MERCHANT, merchantSprite, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, StatusID.MERCHANT));
        this.addIconManager(new StatusIconManager(RPEntity.PROP_PRODUCER, producerSprite, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, StatusID.PRODUCER));
        this.addIconManager(new AbstractStatusIconManager(RPEntity.PROP_EATING, chokingSprite, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM){

            @Override
            boolean show(T t) {
                return ((RPEntity)t).isChoking();
            }
        });
        this.addIconManager(new StatusIconManager(RPEntity.PROP_CONFUSED, confusedSprite, HorizontalAlignment.RIGHT, VerticalAlignment.MIDDLE, StatusID.CONFUSE));
        this.addIconManager(new AbstractStatusIconManager(RPEntity.PROP_EATING, eatingSprite, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM){

            @Override
            boolean show(T t) {
                return ((RPEntity)t).isEating() && !((RPEntity)t).isChoking();
            }
        });
        StatusIconManager statusIconManager = new StatusIconManager(RPEntity.PROP_POISONED, poisonedSprite, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, StatusID.POISON);
        statusIconManager.setOffsets(10, -13);
        this.addIconManager(statusIconManager);
        this.addIconManager(new StatusIconManager(RPEntity.PROP_SHOCK, shockedSprite, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, StatusID.SHOCK));
        StatusIconManager statusIconManager2 = new StatusIconManager(RPEntity.PROP_HEAVY, heavySprite, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, StatusID.HEAVY);
        statusIconManager2.setOffsets(0, 32);
        this.addIconManager(statusIconManager2);
        this.setSpriteAlignment(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    }

    @Override
    public void initialize(T t) {
        super.initialize(t);
        this.showTitle = ((RPEntity)t).showTitle();
        this.showHP = ((RPEntity)t).showHPBar();
        if (this.showTitle) {
            this.titleSprite = this.createTitleSprite();
        }
        this.titleChanged = false;
        this.iconsChanged = true;
    }

    protected void buildSprites(Map<Object, Sprite> map, Sprite sprite, int n, int n2) {
        int n3 = 0;
        map.put((Object)Direction.UP, this.createWalkSprite(sprite, n3, n, n2));
        map.put((Object)Direction.RIGHT, this.createWalkSprite(sprite, n3 += n2, n, n2));
        map.put((Object)Direction.DOWN, this.createWalkSprite(sprite, n3 += n2, n, n2));
        map.put((Object)Direction.LEFT, this.createWalkSprite(sprite, n3 += n2, n, n2));
    }

    private Sprite createTitleSprite() {
        String string = ((RPEntity)this.entity).getTitleType();
        int n = ((RPEntity)this.entity).getAdminLevel();
        Color color = null;
        if (string != null) {
            if (string.equals("npc")) {
                color = new Color(200, 200, 255);
            } else if (string.equals("enemy")) {
                color = new Color(255, 200, 200);
            }
        }
        if (color == null) {
            color = n >= 800 ? new Color(200, 200, 0) : (n >= 400 ? Color.yellow : (n > 0 ? new Color(255, 255, 172) : Color.white));
        }
        return TextSprite.createTextSprite(((RPEntity)this.entity).getTitle(), color);
    }

    protected Sprite createWalkSprite(Sprite sprite, int n, int n2, int n3) {
        SpriteStore spriteStore = SpriteStore.get();
        Sprite[] spriteArray = new Sprite[4];
        int n4 = 0;
        spriteArray[0] = spriteStore.getTile(sprite, n4, n, n2, n3);
        spriteArray[1] = spriteStore.getTile(sprite, n4 += n2, n, n2, n3);
        spriteArray[2] = spriteStore.getTile(sprite, n4 += n2, n, n2, n3);
        spriteArray[3] = spriteArray[1];
        return new AnimatedSprite(spriteArray, 100, false);
    }

    final void addIconManager(AbstractStatusIconManager abstractStatusIconManager) {
        this.iconManagers.add(abstractStatusIconManager);
    }

    private void drawFloaters(Graphics2D graphics2D, int n, int n2, int n3) {
        for (Map.Entry<TextIndicator, Sprite> entry : this.floaters.entrySet()) {
            TextIndicator textIndicator = entry.getKey();
            Sprite sprite = entry.getValue();
            int n4 = textIndicator.getAge();
            int n5 = n + (n3 - sprite.getWidth()) / 2;
            int n6 = n2 - (int)((long)n4 * 5L / 300L);
            sprite.draw(graphics2D, n5, n6);
        }
    }

    protected void drawHPbar(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = (n3 - this.healthBar.getWidth()) / 2;
        this.healthBar.draw(graphics2D, n + n4, n2 - this.healthBar.getHeight() + this.titleDrawYOffset);
    }

    protected void drawStatusBar(Graphics2D graphics2D, int n, int n2, int n3) {
        if (this.showTitle) {
            this.drawTitle(graphics2D, n, n2, n3);
        }
        if (this.showHP) {
            this.drawHPbar(graphics2D, n, n2, n3);
        }
    }

    private int getStatusBarHeight() {
        if (this.titleSprite != null) {
            return 3 + this.titleSprite.getHeight();
        }
        if (this.healthBar != null) {
            return this.healthBar.getHeight();
        }
        return 0;
    }

    protected void drawTitle(Graphics2D graphics2D, int n, int n2, int n3) {
        if (this.titleSprite != null) {
            int n4 = n + (n3 - this.titleSprite.getWidth()) / 2;
            int n5 = n2 - this.getStatusBarHeight() + this.titleDrawYOffset;
            this.titleSprite.draw(graphics2D, n4, n5);
        }
    }

    private void drawCombat(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Rectangle2D rectangle2D = ((RPEntity)this.entity).getArea();
        Rectangle rectangle = new Rectangle((int)(rectangle2D.getX() * 32.0), (int)(rectangle2D.getY() * 32.0), (int)(rectangle2D.getWidth() * 32.0), (int)(rectangle2D.getHeight() * 32.0));
        int n5 = (int)((double)(rectangle.height - 2) / 1.414213562);
        n5 = Math.max(n5, rectangle.height - 16);
        if (((RPEntity)this.entity).isAttacking(User.get())) {
            graphics2D.setColor(RING_COLOR_ORANGE);
            graphics2D.drawOval(rectangle.x - 1, rectangle.y + rectangle.height - n5, rectangle.width, n5);
            graphics2D.drawOval(rectangle.x, rectangle.y + rectangle.height - n5, rectangle.width, n5);
            graphics2D.drawOval(rectangle.x + 1, rectangle.y + rectangle.height - n5, rectangle.width, n5);
            this.drawShadedOval(graphics2D, rectangle.x + 1, rectangle.y + rectangle.height - n5 + 1, rectangle.width - 2, n5 - 2, RING_COLOR_ORANGE, true, false);
        }
        if (((RPEntity)this.entity).isBeingAttacked()) {
            Color color;
            graphics2D.setColor(RING_COLOR_RED);
            if (((RPEntity)this.entity).isAttacking(User.get())) {
                color = RING_COLOR_RED;
                this.drawShadedOval(graphics2D, rectangle.x - 1, rectangle.y + rectangle.height - n5 - 1, rectangle.width + 2, n5 + 2, RING_COLOR_RED, false, true);
            } else {
                color = RING_COLOR_DARK_RED;
                graphics2D.drawOval(rectangle.x - 1, rectangle.y + rectangle.height - n5, rectangle.width, n5);
                graphics2D.drawOval(rectangle.x, rectangle.y + rectangle.height - n5, rectangle.width, n5);
                graphics2D.drawOval(rectangle.x + 1, rectangle.y + rectangle.height - n5, rectangle.width, n5);
                this.drawShadedOval(graphics2D, rectangle.x + 1, rectangle.y + rectangle.height - n5 + 1, rectangle.width - 2, n5 - 2, RING_COLOR_RED, true, false);
                this.drawShadedOval(graphics2D, rectangle.x - 1, rectangle.y + rectangle.height - n5 - 1, rectangle.width + 2, n5 + 2, RING_COLOR_ORANGE, false, false);
            }
            EnumSet<Direction> enumSet = EnumSet.noneOf(Direction.class);
            for (Entity entity : ((RPEntity)this.entity).getAttackers()) {
                enumSet.add(Direction.getAreaDirectionTowardsArea(((RPEntity)this.entity).getArea(), entity.getArea()));
            }
            this.drawArrows(graphics2D, rectangle.x - 1, rectangle.y + rectangle.height - n5 - 1, rectangle.width + 2, n5 + 2, enumSet, color);
        } else if (((RPEntity)this.entity).isAttacking(User.get())) {
            this.drawShadedOval(graphics2D, rectangle.x - 1, rectangle.y + rectangle.height - n5 - 1, rectangle.width + 2, n5 + 2, RING_COLOR_ORANGE, false, false);
        }
        this.drawAttack(graphics2D, n, n2, n3, n4);
        if (((RPEntity)this.entity).isDefending()) {
            int n6 = rectangle.x + rectangle.width - 8;
            int n7 = n2 + n4 - 16;
            switch (((RPEntity)this.entity).getResolution()) {
                case BLOCKED: {
                    blockedSprite.draw(graphics2D, n6, n7);
                    break;
                }
                case MISSED: {
                    missedSprite.draw(graphics2D, n6, n7);
                    break;
                }
                case HIT: {
                    hitSprite.draw(graphics2D, n6, n7);
                    break;
                }
            }
        }
    }

    private void drawArrows(Graphics2D graphics2D, int n, int n2, int n3, int n4, EnumSet<Direction> enumSet, Color color) {
        int n5 = 6 + 2 * (n4 / 23 - 1);
        int n6 = 3 + (n3 / 34 - 1);
        if (enumSet.contains((Object)Direction.LEFT)) {
            graphics2D.setColor(Color.RED);
            graphics2D.fillPolygon(new int[]{n + 1, n - n6, n + 1}, new int[]{n2 + n4 / 2 - n5 / 2, n2 + n4 / 2, n2 + n4 / 2 + n5 / 2}, 3);
            graphics2D.setColor(color);
            graphics2D.drawPolyline(new int[]{n, n - n6, n}, new int[]{n2 + n4 / 2 - n5 / 2, n2 + n4 / 2, n2 + n4 / 2 + n5 / 2}, 3);
        }
        if (enumSet.contains((Object)Direction.RIGHT)) {
            graphics2D.setColor(Color.RED);
            graphics2D.fillPolygon(new int[]{n + n3, n + n3 + n6, n + n3}, new int[]{n2 + n4 / 2 - n5 / 2, n2 + n4 / 2, n2 + n4 / 2 + n5 / 2}, 3);
            graphics2D.setColor(color);
            graphics2D.drawPolyline(new int[]{n + n3, n + n3 + n6, n + n3}, new int[]{n2 + n4 / 2 - n5 / 2, n2 + n4 / 2, n2 + n4 / 2 + n5 / 2}, 3);
        }
        if (enumSet.contains((Object)Direction.UP)) {
            graphics2D.setColor(Color.RED);
            graphics2D.fillPolygon(new int[]{n + n3 / 2 - n5 / 2, n + n3 / 2, n + n3 / 2 + n5 / 2}, new int[]{n2 + 1, n2 - n6, n2 + 1}, 3);
            graphics2D.setColor(color);
            graphics2D.drawPolyline(new int[]{n + n3 / 2 - n5 / 2, n + n3 / 2, n + n3 / 2 + n5 / 2}, new int[]{n2, n2 - n6, n2}, 3);
        }
        if (enumSet.contains((Object)Direction.DOWN)) {
            graphics2D.setColor(Color.RED);
            graphics2D.fillPolygon(new int[]{n + n3 / 2 - n5 / 2, n + n3 / 2, n + n3 / 2 + n5 / 2}, new int[]{n2 + n4, n2 + n4 + n6, n2 + n4}, 3);
            graphics2D.setColor(color);
            graphics2D.drawPolyline(new int[]{n + n3 / 2 - n5 / 2, n + n3 / 2, n + n3 / 2 + n5 / 2}, new int[]{n2 + n4, n2 + n4 + n6, n2 + n4}, 3);
        }
    }

    private void drawShadedOval(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, boolean bl, boolean bl2) {
        float f;
        float f2;
        if (bl2) {
            f2 = bl ? 1.0f : 0.8f;
            f = bl ? 0.8f : 1.0f;
        } else {
            f2 = bl ? 0.24f : 0.39f;
            f = bl ? 0.39f : 0.24f;
        }
        Color color2 = new Color((int)((float)color.getRed() * f2), (int)((float)color.getGreen() * f2), (int)((float)color.getBlue() * f2));
        Color color3 = new Color((int)((float)color.getRed() * f), (int)((float)color.getGreen() * f), (int)((float)color.getBlue() * f));
        graphics2D.setColor(color2);
        graphics2D.drawArc(n, n2, n3, n4, 0, 180);
        graphics2D.setColor(color3);
        graphics2D.drawArc(n, n2, n3, n4, 180, 180);
    }

    private void drawAttack(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.isAttacking) {
            if (!this.attackPainter.isDoneAttacking()) {
                RPEntity rPEntity = ((RPEntity)this.entity).getAttackTarget();
                if (rPEntity != null) {
                    if (this.rangedAttack) {
                        this.attackPainter.drawDistanceAttack(graphics2D, (RPEntity)this.entity, rPEntity, n, n2, n3, n4);
                    } else {
                        this.attackPainter.draw(graphics2D, ((RPEntity)this.entity).getDirection(), n, n2, n3, n4);
                    }
                }
            } else {
                this.isAttacking = false;
            }
        }
    }

    protected abstract Sprite getAnimationSprite();

    protected Sprite addShadow(Sprite sprite) {
        boolean bl = WtWindowManager.getInstance().getProperty("gamescreen.shadows", "true").equals("true");
        if (bl && ((RPEntity)this.entity).castsShadow()) {
            String string = ((RPEntity)this.entity).getShadowStyle();
            if (string != null && DataLoader.getResource(string) != null) {
                ImageSprite imageSprite = new ImageSprite(SpriteStore.get().getSprite(string));
                Graphics graphics = imageSprite.getGraphics();
                sprite.draw(graphics, 0, 0);
                return imageSprite;
            }
            int n = sprite.getWidth() / 3;
            int n2 = sprite.getHeight() / 4;
            String string2 = "data/sprites/shadow/" + Integer.toString(n) + "x" + Integer.toString(n2) + ".png";
            if (DataLoader.getResource(string2) != null) {
                ImageSprite imageSprite = new ImageSprite(SpriteStore.get().getSprite(string2));
                Graphics graphics = imageSprite.getGraphics();
                sprite.draw(graphics, 0, 0);
                return imageSprite;
            }
        }
        return sprite;
    }

    protected int getTilesX() {
        return 3;
    }

    protected int getTilesY() {
        return 4;
    }

    protected boolean isVisibleGhost() {
        return false;
    }

    @Override
    protected void buildSprites(T t, Map<Object, Sprite> map) {
        Sprite sprite = this.getAnimationSprite();
        this.width = sprite.getWidth() / this.getTilesX();
        this.height = sprite.getHeight() / this.getTilesY();
        this.buildSprites(map, sprite, this.width, this.height);
        this.calculateOffset(t, this.width, this.height);
        this.checkIcons();
        int n = Math.max(this.width * 2 / 3, 32);
        this.healthBar = new HealthBar(n, 4);
        this.healthBar.setHPRatio(((RPEntity)t).getHpRatio());
    }

    private void checkIcons() {
        for (AbstractStatusIconManager abstractStatusIconManager : this.iconManagers) {
            if (!abstractStatusIconManager.check((RPEntity)this.entity)) continue;
            this.iconsChanged = true;
        }
    }

    private void checkIcons(Object object) {
        for (AbstractStatusIconManager abstractStatusIconManager : this.iconManagers) {
            if (!abstractStatusIconManager.check(object, (RPEntity)this.entity)) continue;
            this.iconsChanged = true;
        }
    }

    @Override
    protected void buildActions(List<String> list) {
        super.buildActions(list);
        RPObject rPObject = ((RPEntity)this.entity).getRPObject();
        if (!rPObject.has("no_attack") && !((RPEntity)this.entity).getRPObject().has("menu")) {
            if (((RPEntity)this.entity).isAttackedBy(User.get())) {
                list.add(ActionType.STOP_ATTACK.getRepresentation());
            } else {
                list.add(ActionType.ATTACK.getRepresentation());
            }
        }
        list.add(ActionType.PUSH.getRepresentation());
    }

    @Override
    protected void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.drawCombat(graphics2D, n, n2, n3, n4);
        super.draw(graphics2D, n, n2, n3, n4);
    }

    @Override
    protected void drawTop(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.drawFloaters(graphics2D, n, n2, n3);
        this.drawStatusBar(graphics2D, n, n2 + this.statusBarYOffset, n3);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    protected int getVisibility() {
        if (((RPEntity)this.entity).isGhostMode()) {
            if (this.isVisibleGhost()) {
                return super.getVisibility() / 2;
            }
            return 0;
        }
        return super.getVisibility();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getZIndex() {
        return 8000;
    }

    @Override
    public void setVisibleScreenArea(Rectangle rectangle) {
        Rectangle rectangle2 = this.getDrawingArea();
        int n = rectangle2.y - this.getStatusBarHeight();
        int n2 = rectangle.y;
        this.statusBarYOffset = Math.max(0, n2 - n);
    }

    @Override
    protected void update() {
        super.update();
        if (this.titleChanged) {
            this.titleChanged = false;
            this.showTitle = ((RPEntity)this.entity).showTitle();
            this.titleSprite = this.showTitle ? this.createTitleSprite() : null;
        }
        if (this.iconsChanged) {
            this.iconsChanged = false;
            for (AbstractStatusIconManager abstractStatusIconManager : this.iconManagers) {
                abstractStatusIconManager.apply();
            }
        }
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == RPEntity.PROP_ADMIN_LEVEL) {
            this.titleChanged = true;
            this.visibilityChanged = true;
        } else if (object == RPEntity.PROP_GHOSTMODE) {
            this.visibilityChanged = true;
        } else if (object == RPEntity.PROP_OUTFIT || object == RPEntity.PROP_ZOMBIE) {
            this.representationChanged = true;
        } else if (object == IEntity.PROP_TITLE || object == RPEntity.PROP_TITLE_TYPE) {
            this.titleChanged = true;
        } else if (object == RPEntity.PROP_TEXT_INDICATORS) {
            this.onFloatersChanged();
        } else if (object == RPEntity.PROP_HP_RATIO) {
            if (this.healthBar != null) {
                this.healthBar.setHPRatio(((RPEntity)this.entity).getHpRatio());
            }
        } else if (object == RPEntity.PROP_HP_DISPLAY) {
            this.showHP = ((RPEntity)this.entity).showHPBar();
        } else if (object == RPEntity.PROP_ATTACK) {
            Nature nature = ((RPEntity)this.entity).getShownDamageType();
            String string = ((RPEntity)this.entity).getShownWeapon();
            if (nature == null) {
                this.isAttacking = false;
            } else {
                this.rangedAttack = ((RPEntity)this.entity).isDoingRangedAttack();
                if (this.attackPainter == null || !this.attackPainter.hasNatureAndWeapon(nature, string)) {
                    this.attackPainter = AttackPainter.get(nature, string, (int)Math.min(((RPEntity)this.entity).getWidth(), ((RPEntity)this.entity).getHeight()));
                }
                this.attackPainter.prepare(this.getState((ActiveEntity)this.entity));
                this.isAttacking = true;
            }
        }
        this.checkIcons(object);
    }

    private void onFloatersChanged() {
        Iterator<TextIndicator> iterator = ((RPEntity)this.entity).getTextIndicators();
        HashMap<TextIndicator, Sprite> hashMap = new HashMap<TextIndicator, Sprite>();
        while (iterator.hasNext()) {
            TextIndicator textIndicator = iterator.next();
            Sprite sprite = this.floaters.get(textIndicator);
            if (sprite == null) {
                sprite = TextSprite.createTextSprite(textIndicator.getText(), textIndicator.getType().getColor());
            }
            hashMap.put(textIndicator, sprite);
        }
        this.floaters = hashMap;
    }

    @Override
    public void onAction() {
        if (((RPEntity)this.entity).getRPObject().has("menu")) {
            this.onAction(ActionType.USE);
        } else {
            super.onAction();
        }
    }

    @Override
    public void onAction(ActionType actionType) {
        ActionType actionType2 = actionType;
        if (actionType2 == null) {
            actionType2 = ActionType.USE;
        }
        if (this.isReleased()) {
            return;
        }
        switch (actionType2) {
            case ATTACK: 
            case PUSH: 
            case USE: {
                actionType2.send(actionType2.fillTargetInfo(this.entity));
                break;
            }
            case STOP_ATTACK: {
                RPAction rPAction = new RPAction();
                rPAction.put("type", actionType2.toString());
                rPAction.put("attack", "");
                actionType2.send(rPAction);
                break;
            }
            default: {
                super.onAction(actionType2);
            }
        }
    }

    static {
        RING_COLOR_RED = new Color(230, 10, 10);
        RING_COLOR_DARK_RED = new Color(74, 0, 0);
        RING_COLOR_ORANGE = new Color(255, 200, 0);
        SpriteStore spriteStore = SpriteStore.get();
        hitSprite = spriteStore.getCombatSprite("hitted.png");
        blockedSprite = spriteStore.getCombatSprite("blocked.png");
        missedSprite = spriteStore.getCombatSprite("missed.png");
        healerSprite = spriteStore.getStatusSprite("healer.png");
        merchantSprite = spriteStore.getStatusSprite("merchant.png");
        producerSprite = spriteStore.getStatusSprite("producer.png");
        confusedSprite = spriteStore.getAnimatedSprite(spriteStore.getStatusSprite("confuse.png"), 200);
        eatingSprite = spriteStore.getSprite("data/sprites/ideas/eat.png");
        poisonedSprite = spriteStore.getAnimatedSprite(spriteStore.getStatusSprite("poison.png"), 100);
        chokingSprite = spriteStore.getSprite("data/sprites/ideas/choking.png");
        shockedSprite = spriteStore.getAnimatedSprite(spriteStore.getStatusSprite("shock.png"), 38, 200);
        heavySprite = spriteStore.getAnimatedSprite(spriteStore.getStatusSprite("heavy.png"), 200);
    }

    abstract class AbstractStatusIconManager {
        private final Object property;
        private final Sprite sprite;
        private final HorizontalAlignment xAlign;
        private final VerticalAlignment yAlign;
        private int xOffset;
        private int yOffset;
        private boolean wasVisible;
        private boolean shouldBeVisible;
        private volatile boolean changed;

        AbstractStatusIconManager(Object object, Sprite sprite, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
            this.property = object;
            this.sprite = sprite;
            this.xAlign = horizontalAlignment;
            this.yAlign = verticalAlignment;
        }

        abstract boolean show(T var1);

        boolean check(Object object, T t) {
            if (this.property == object) {
                return this.check(t);
            }
            return false;
        }

        void apply() {
            if (this.changed) {
                this.changed = false;
                this.setVisible(this.shouldBeVisible);
            }
        }

        void setOffsets(int n, int n2) {
            this.xOffset = n;
            this.yOffset = n2;
        }

        private boolean check(T t) {
            boolean bl;
            boolean bl2 = this.shouldBeVisible;
            this.shouldBeVisible = this.show(t);
            boolean bl3 = bl = bl2 != this.shouldBeVisible;
            if (bl) {
                this.changed = true;
            }
            return bl;
        }

        private void position() {
            if (this.xAlign == HorizontalAlignment.CENTER) {
                return;
            }
            this.xOffset = 0;
            for (int i = 0; i < RPEntity2DView.this.iconManagers.size(); ++i) {
                AbstractStatusIconManager abstractStatusIconManager = (AbstractStatusIconManager)RPEntity2DView.this.iconManagers.get(i);
                if (abstractStatusIconManager != this) {
                    if (!this.sharesPosition(abstractStatusIconManager)) continue;
                    if (this.xAlign == HorizontalAlignment.LEFT) {
                        this.xOffset += abstractStatusIconManager.sprite.getWidth();
                        continue;
                    }
                    this.xOffset -= abstractStatusIconManager.sprite.getWidth();
                    continue;
                }
                this.reposition(i + 1);
                break;
            }
        }

        private void reposition(int n) {
            for (int i = n; i < RPEntity2DView.this.iconManagers.size(); ++i) {
                AbstractStatusIconManager abstractStatusIconManager = (AbstractStatusIconManager)RPEntity2DView.this.iconManagers.get(i);
                if (!this.sharesPosition(abstractStatusIconManager)) continue;
                abstractStatusIconManager.setVisible(false);
                abstractStatusIconManager.position();
                abstractStatusIconManager.setVisible(true);
                break;
            }
        }

        private boolean sharesPosition(AbstractStatusIconManager abstractStatusIconManager) {
            return abstractStatusIconManager.xAlign == this.xAlign && abstractStatusIconManager.yAlign == this.yAlign && abstractStatusIconManager.shouldBeVisible;
        }

        private void setVisible(boolean bl) {
            if (bl) {
                if (!this.wasVisible) {
                    this.position();
                    RPEntity2DView.this.attachSprite(this.sprite, this.xAlign, this.yAlign, this.xOffset, this.yOffset);
                    this.wasVisible = true;
                }
            } else {
                this.wasVisible = false;
                RPEntity2DView.this.detachSprite(this.sprite);
                this.reposition(RPEntity2DView.this.iconManagers.indexOf(this) + 1);
            }
        }
    }

    private class StatusIconManager
    extends AbstractStatusIconManager {
        private final StatusID status;

        StatusIconManager(Object object, Sprite sprite, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, StatusID statusID) {
            super(object, sprite, horizontalAlignment, verticalAlignment);
            this.status = statusID;
        }

        @Override
        boolean show(T t) {
            return ((RPEntity)t).hasStatus(this.status);
        }
    }
}

