/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.j2d.entity.Player2DView;
import java.util.List;

class User2DView<T extends User>
extends Player2DView<T> {
    User2DView() {
    }

    @Override
    public void initialize(T t) {
        boolean bl = this.entity == null;
        super.initialize(t);
        if (bl) {
            j2DClient.get().setPosition(((Entity)t).getX(), ((Entity)t).getY());
        }
    }

    @Override
    protected boolean isVisibleGhost() {
        return true;
    }

    @Override
    protected void buildActions(List<String> list) {
        super.buildActions(list);
        list.remove(ActionType.ATTACK.getRepresentation());
        list.remove(ActionType.ADD_BUDDY.getRepresentation());
        list.remove(ActionType.IGNORE.getRepresentation());
        list.remove(ActionType.UNIGNORE.getRepresentation());
        list.remove(ActionType.PUSH.getRepresentation());
        list.remove(ActionType.TRADE.getRepresentation());
        list.remove(ActionType.INVITE.getRepresentation());
        if (((User)this.getEntity()).stopped()) {
            list.add(ActionType.WALK_START.getRepresentation());
        } else {
            list.add(ActionType.WALK_STOP.getRepresentation());
        }
        list.add(ActionType.SET_OUTFIT.getRepresentation());
        list.add(ActionType.WHERE.getRepresentation());
        User user = (User)this.entity;
        if (user != null) {
            if (user.hasSheep()) {
                list.add(ActionType.LEAVE_SHEEP.getRepresentation());
            }
            if (user.hasPet()) {
                list.add(ActionType.LEAVE_PET.getRepresentation());
            }
        }
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_POSITION) {
            j2DClient.get().setPosition(((User)this.entity).getX(), ((User)this.entity).getY());
        }
    }

    @Override
    public void onAction(ActionType actionType) {
        if (actionType == null) {
            super.onAction(null);
            return;
        }
        switch (actionType) {
            case SET_OUTFIT: {
                j2DClient.get().chooseOutfit();
                break;
            }
            case WALK_START: 
            case WALK_STOP: 
            case WHERE: 
            case LEAVE_SHEEP: 
            case LEAVE_PET: {
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }
}

