/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

class Wall2DView
extends Entity2DView<IEntity> {
    Wall2DView() {
    }

    @Override
    protected void buildRepresentation(IEntity iEntity) {
        SpriteStore spriteStore = SpriteStore.get();
        ZoneInfo zoneInfo = ZoneInfo.get();
        Sprite sprite = spriteStore.getModifiedSprite(this.translate(this.getClassResourcePath()), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        int n = (int)iEntity.getWidth();
        int n2 = (int)iEntity.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n * 32, n2 * 32, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                sprite.draw(graphics2D, i * 32, j * 32);
            }
        }
        this.setSprite(new ImageSprite(bufferedImage));
    }

    @Override
    public int getZIndex() {
        return 1000;
    }

    @Override
    protected String translate(String string) {
        return "data/sprites/" + string + ".png";
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.NORMAL;
    }
}

