/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Timer;

public class AnimatedLayout
implements LayoutManager2 {
    private LayoutManager2 proxy;
    private Map<Container, Animator> animations;
    private boolean animated = true;

    public AnimatedLayout(LayoutManager2 layoutManager2) {
        this.proxy = layoutManager2;
        this.animations = new WeakHashMap<Container, Animator>(5);
    }

    public void setAnimated(boolean bl) {
        if (this.animated != bl) {
            this.animated = bl;
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.proxy.addLayoutComponent(string, component);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.proxy.removeLayoutComponent(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.proxy.preferredLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.proxy.minimumLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        Object object;
        if (!this.animated) {
            this.proxy.layoutContainer(container);
            return;
        }
        HashMap<Component, Rectangle> hashMap = new HashMap<Component, Rectangle>(container.getComponentCount());
        for (Component component : container.getComponents()) {
            hashMap.put(component, new Rectangle(component.getBounds()));
        }
        this.proxy.layoutContainer(container);
        ArrayList arrayList = new ArrayList();
        for (Component component : container.getComponents()) {
            Rectangle rectangle = component.getBounds();
            Rectangle rectangle2 = (Rectangle)hashMap.get(component);
            if (rectangle2.equals(rectangle)) continue;
            component.setBounds(rectangle2);
            arrayList.add(new BoundData(component, rectangle2, rectangle));
        }
        if (!arrayList.isEmpty()) {
            object = this.animations.get(container);
            if (object == null) {
                object = new Animator(container, arrayList);
                this.animations.put(container, (Animator)object);
            } else {
                ((Animator)object).setBounds(arrayList);
            }
            ((Animator)object).restart();
        } else {
            object = this.animations.get(container);
            if (object != null) {
                ((Animator)object).stop();
                this.animations.remove(container);
            }
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.proxy.addLayoutComponent(component, object);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.proxy.maximumLayoutSize(container);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return this.proxy.getLayoutAlignmentX(container);
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return this.proxy.getLayoutAlignmentY(container);
    }

    @Override
    public void invalidateLayout(Container container) {
        this.proxy.invalidateLayout(container);
    }

    private static class Animator
    implements ActionListener {
        private static final double MINIMUM_SPEED = 0.032;
        private final Timer timer;
        private Container parent;
        private Collection<BoundData> boundList;
        private double progress;
        private double progressRate;

        Animator(Container container, Collection<BoundData> collection) {
            this.setBounds(collection);
            this.timer = new Timer(16, this);
            this.parent = container;
        }

        final void setBounds(Collection<BoundData> collection) {
            int n = 0;
            for (BoundData boundData : collection) {
                n = Math.max(n, boundData.getMaxDistance());
            }
            this.progressRate = Math.max(0.032, 1.0 / (double)n);
            this.boundList = collection;
        }

        void restart() {
            this.progress = 0.0;
            this.timer.restart();
        }

        void stop() {
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.progress += this.progressRate;
            if (this.progress >= 1.0) {
                this.progress = 1.0;
                this.timer.stop();
            }
            for (BoundData boundData : this.boundList) {
                Component component = boundData.getComponent();
                component.setBounds(boundData.getBounds(this.progress));
            }
            this.parent.repaint();
        }
    }

    private static class BoundData {
        private final Component component;
        private final Rectangle startBounds;
        private final Rectangle finalBounds;

        BoundData(Component component, Rectangle rectangle, Rectangle rectangle2) {
            this.component = component;
            this.startBounds = rectangle;
            this.finalBounds = rectangle2;
        }

        Component getComponent() {
            return this.component;
        }

        int getMaxDistance() {
            int n = Math.abs(this.startBounds.x - this.finalBounds.x);
            n = Math.max(n, Math.abs(this.startBounds.x + this.startBounds.width - this.finalBounds.x - this.finalBounds.width));
            n = Math.max(n, Math.abs(this.startBounds.y - this.finalBounds.y));
            return Math.max(n, Math.abs(this.startBounds.y + this.startBounds.height - this.finalBounds.y - this.finalBounds.height));
        }

        Rectangle getBounds(double d) {
            return this.interpolate(this.startBounds, this.finalBounds, d);
        }

        private Rectangle interpolate(Rectangle rectangle, Rectangle rectangle2, double d) {
            Rectangle rectangle3 = new Rectangle();
            rectangle3.setLocation(this.interpolate(rectangle.getLocation(), rectangle2.getLocation(), d));
            rectangle3.setSize(this.interpolate(rectangle.getSize(), rectangle2.getSize(), d));
            return rectangle3;
        }

        private Dimension interpolate(Dimension dimension, Dimension dimension2, double d) {
            Dimension dimension3 = new Dimension();
            dimension3.width = this.interpolate(dimension.width, dimension2.width, d);
            dimension3.height = this.interpolate(dimension.height, dimension2.height, d);
            return dimension3;
        }

        private Point interpolate(Point point, Point point2, double d) {
            Point point3 = new Point();
            point3.x = this.interpolate(point.x, point2.x, d);
            point3.y = this.interpolate(point.y, point2.y, d);
            return point3;
        }

        private int interpolate(int n, int n2, double d) {
            int n3 = n2 - n;
            double d2 = d <= 0.5 ? 2.0 * d * d : -2.0 * d * d + 4.0 * d - 1.0;
            return (int)((double)n3 * d2) + n;
        }
    }
}

