/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.login;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.gui.NumberDocumentFilter;
import games.stendhal.client.gui.ProgressBar;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.stendhal;
import games.stendhal.client.update.ClientGameConfiguration;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import marauroa.client.BannedAddressException;
import marauroa.client.LoginFailedException;
import marauroa.client.TimeoutException;
import marauroa.common.game.AccountResult;
import marauroa.common.net.InvalidVersionException;
import org.apache.log4j.Logger;

public class CreateAccountDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(CreateAccountDialog.class);
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JPasswordField passwordretypeField;
    private JTextField emailField;
    private JTextField serverField;
    private JTextField serverPortField;
    private StendhalClient client;
    private String badEmailTitle;
    private String badEmailReason;
    private String badPasswordReason;

    public CreateAccountDialog(Frame frame, StendhalClient stendhalClient) {
        super(frame, true);
        this.client = stendhalClient;
        this.initializeComponent(frame);
        WindowUtils.closeOnEscape(this);
        this.setVisible(true);
    }

    CreateAccountDialog() {
        this.initializeComponent(null);
    }

    private void initializeComponent(final Frame frame) {
        this.setDefaultCloseOperation(2);
        if (frame != null) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    frame.setEnabled(true);
                }
            });
        }
        JLabel jLabel = new JLabel("Server name");
        this.serverField = new JTextField(ClientGameConfiguration.get((String)"DEFAULT_SERVER"));
        this.serverField.setEditable(true);
        JLabel jLabel2 = new JLabel("Server port");
        this.serverPortField = new JTextField(ClientGameConfiguration.get((String)"DEFAULT_PORT"));
        ((AbstractDocument)this.serverPortField.getDocument()).setDocumentFilter(new NumberDocumentFilter(this.serverPortField, false));
        JLabel jLabel3 = new JLabel("Choose a username");
        this.usernameField = new JTextField();
        this.usernameField.setDocument(new LowerCaseLetterDocument());
        JLabel jLabel4 = new JLabel("Choose a password");
        this.passwordField = new JPasswordField();
        JLabel jLabel5 = new JLabel("Retype password");
        this.passwordretypeField = new JPasswordField();
        JLabel jLabel6 = new JLabel("E-mail address (optional)");
        this.emailField = new JTextField();
        JButton jButton = new JButton();
        jButton.setText("Create Account");
        jButton.setMnemonic(65);
        this.rootPane.setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateAccountDialog.this.onCreateAccount();
            }
        });
        int n = 5;
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new SBoxLayout(false, n));
        jPanel.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        JComponent jComponent = new JComponent(){};
        jComponent.setLayout(new GridLayout(0, 2, n, n));
        jPanel.add((Component)jComponent, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
        jComponent.add(jLabel);
        jComponent.add(this.serverField);
        jComponent.add(jLabel2);
        jComponent.add(this.serverPortField);
        jComponent.add(jLabel3);
        jComponent.add(this.usernameField);
        jComponent.add(jLabel4);
        jComponent.add(this.passwordField);
        jComponent.add(jLabel5);
        jComponent.add(this.passwordretypeField);
        jComponent.add(jLabel6);
        jComponent.add(this.emailField);
        jComponent.add(new JComponent(){});
        JCheckBox jCheckBox = new JCheckBox("Show password");
        jCheckBox.setHorizontalAlignment(4);
        final char c = this.passwordField.getEchoChar();
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                char c2 = itemEvent.getStateChange() == 1 ? (char)'\u0000' : c;
                CreateAccountDialog.this.passwordField.setEchoChar(c2);
                CreateAccountDialog.this.passwordretypeField.setEchoChar(c2);
            }
        });
        jComponent.add(jCheckBox);
        JLabel jLabel7 = new JLabel("<html><body><p><font size=\"-2\">On login, information which identifies your computer on the Internet<br>will be logged to prevent abuse (like many attempts to guess a<br>password or the creation of many accounts to cause trouble).</font></p><p><font size=\"-2\">Furthermore all events and actions that happen within the game-<br>world (like solving quests, attacking monsters) are logged. This<br>information is used to analyse bugs and in rare cases for abuse handling.</font></p><br><p><font size=\"-2\">Stendhal is a non-commercial spare time project. We do NOT use your<br>data for advertisment. We do NOT make it available to third parties.</font></p></body></html>");
        jLabel7.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        jLabel7.setAlignmentX(0.5f);
        jPanel.add((Component)jLabel7, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
        JComponent jComponent2 = SBoxLayout.createContainer(true, 5);
        jComponent2.setAlignmentX(1.0f);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateAccountDialog.this.dispatchEvent(new WindowEvent(CreateAccountDialog.this, 201));
            }
        });
        jComponent2.add(jButton2);
        jComponent2.add(jButton);
        jPanel.add(jComponent2);
        this.setTitle("Create New Account");
        this.setResizable(false);
        this.pack();
        this.usernameField.requestFocusInWindow();
        if (frame != null) {
            frame.setEnabled(false);
            this.setLocationRelativeTo(frame);
        }
    }

    private void onCreateAccount() {
        final String string = this.usernameField.getText();
        final String string2 = new String(this.passwordField.getPassword());
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = this.checkFields();
        if (!bl) {
            return;
        }
        final String string3 = this.emailField.getText();
        final String string4 = this.serverField.getText();
        int n = 32160;
        final ProgressBar progressBar = new ProgressBar(this);
        try {
            n = Integer.parseInt(this.serverPortField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.getOwner(), "That is not a valid port number. Please try again.", "Invalid Port", 2);
            return;
        }
        final int n2 = n;
        if (this.client == null) {
            JOptionPane.showMessageDialog(this, "Account not created (running standalone)!");
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                progressBar.start();
                CreateAccountDialog.this.setEnabled(false);
                try {
                    CreateAccountDialog.this.client.connect(string4, n2);
                    progressBar.step();
                }
                catch (Exception exception) {
                    progressBar.cancel();
                    CreateAccountDialog.this.setEnabled(true);
                    JOptionPane.showMessageDialog(CreateAccountDialog.this.getOwner(), "Unable to connect to server to create your account. The server may be down or, if you are using a custom server, you may have entered its name and port number incorrectly.");
                    LOGGER.error((Object)exception, (Throwable)exception);
                    return;
                }
                Window window = CreateAccountDialog.this.getOwner();
                try {
                    AccountResult accountResult = CreateAccountDialog.this.client.createAccount(string, string2, string3);
                    if (accountResult.failed()) {
                        progressBar.cancel();
                        CreateAccountDialog.this.setEnabled(true);
                        JOptionPane.showMessageDialog(window, accountResult.getResult().getText(), "Create account failed", 0);
                    } else {
                        progressBar.step();
                        progressBar.finish();
                        CreateAccountDialog.this.client.setAccountUsername(string);
                        CreateAccountDialog.this.client.setCharacter(string);
                        CreateAccountDialog.this.client.login(string, string2);
                        progressBar.step();
                        progressBar.finish();
                        CreateAccountDialog.this.setEnabled(false);
                        if (window != null) {
                            window.setVisible(false);
                            window.dispose();
                        }
                        stendhal.setDoLogin();
                    }
                }
                catch (TimeoutException timeoutException) {
                    progressBar.cancel();
                    CreateAccountDialog.this.setEnabled(true);
                    JOptionPane.showMessageDialog(window, "Unable to connect to server to create your account. The server may be down or, if you are using a custom server, you may have entered its name and port number incorrectly.", "Error Creating Account", 0);
                }
                catch (InvalidVersionException invalidVersionException) {
                    progressBar.cancel();
                    CreateAccountDialog.this.setEnabled(true);
                    JOptionPane.showMessageDialog(window, "You are running an incompatible version of Stendhal. Please update", "Invalid version", 0);
                }
                catch (BannedAddressException bannedAddressException) {
                    progressBar.cancel();
                    CreateAccountDialog.this.setEnabled(true);
                    JOptionPane.showMessageDialog(window, "Your IP is banned.", "IP Banned", 0);
                }
                catch (LoginFailedException loginFailedException) {
                    progressBar.cancel();
                    CreateAccountDialog.this.setEnabled(true);
                    JOptionPane.showMessageDialog(window, loginFailedException.getMessage(), "Login failed", 1);
                }
            }
        };
        thread.start();
    }

    private boolean checkFields() {
        String string;
        int n;
        String string2;
        String string3 = new String(this.passwordField.getPassword());
        String string4 = new String(this.passwordretypeField.getPassword());
        Window window = this.getOwner();
        if (!string3.equals(string4)) {
            JOptionPane.showMessageDialog(window, "The passwords do not match. Please retype both.", "Password Mismatch", 2);
            return false;
        }
        boolean bl = this.validatePassword(this.usernameField.getText(), string3);
        if (!bl) {
            if (this.badPasswordReason != null) {
                int n2 = JOptionPane.showOptionDialog(window, this.badPasswordReason, "Bad Password", 0, 2, null, null, 1);
                if (n2 == 1) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return this.validateEmail(string2 = this.emailField.getText().trim()) || (n = JOptionPane.showOptionDialog(window, string = this.badEmailReason + "An email address is the only means for administrators to contact with the legitimate owner of an account.\nIf you don't provide one then you won't be able to get a new password for this account if, for example:\n- You forget your password.\n- Another player somehow gets your password and changes it.\nDo you want to continue anyway?", this.badEmailTitle, 0, 2, null, null, 1)) == 0;
    }

    private boolean validateEmail(String string) {
        if (string.isEmpty()) {
            this.badEmailTitle = "Email address is empty";
            this.badEmailReason = "You didn't enter an email address.\n";
            return false;
        }
        if (!string.contains("@") || !string.contains(".") || string.length() <= 5) {
            this.badEmailTitle = "Misspelled email address?";
            this.badEmailReason = "The email address you entered is probably misspelled.\n";
            return false;
        }
        return true;
    }

    private void debug(String string) {
        if (this.client == null) {
            LOGGER.debug((Object)string);
        }
    }

    public static void main(String[] stringArray) {
        new CreateAccountDialog(null, null);
    }

    boolean validatePassword(String string, String string2) {
        if (string2.length() > 5) {
            boolean bl = true;
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (bl) {
                this.badPasswordReason = "You have used only numbers in your password. This is not a good security practice.\n Are you sure that you want to use this password?";
            }
            boolean bl2 = false;
            if (string2.contains(string)) {
                bl2 = true;
            }
            if (!bl2) {
                String string3;
                int n;
                this.debug("Checking if password contains a derivative of the username, trimming from the back...");
                for (n = 1; n < string.length(); ++n) {
                    string3 = string.substring(0, string.length() - n);
                    this.debug("\tchecking for \"" + string3 + "\"...");
                    if (string3.length() <= 3) break;
                    if (!string2.contains(string3)) continue;
                    bl2 = true;
                    this.debug("Password contains username!");
                    break;
                }
                if (!bl2) {
                    this.debug("Checking if password contains a derivative of the username, trimming from the front...");
                    for (n = 0; n < string.length(); ++n) {
                        string3 = string.substring(n);
                        this.debug("\tchecking for \"" + string3 + "\"...");
                        if (string3.length() <= 3) break;
                        if (!string2.contains(string3)) continue;
                        bl2 = true;
                        this.debug("Password contains username!");
                        break;
                    }
                }
            }
            if (bl2) {
                this.badPasswordReason = "You have used your username or a derivative of your username in your password. This is a bad security practice.\n Are you sure that you want to use this password?";
                return false;
            }
        } else {
            if (this.isVisible()) {
                JOptionPane.showMessageDialog(this.getOwner(), "The password you provided is too short. It must be at least 6 characters long.");
            } else {
                LOGGER.warn((Object)"The password you provided is too short. It must be at least 6 characters long.");
            }
            return false;
        }
        return true;
    }

    private static class LowerCaseLetterDocument
    extends PlainDocument {
        private LowerCaseLetterDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = string.toLowerCase(Locale.ENGLISH);
            boolean bl = true;
            for (int i = string2.length() - 1; i >= 0; --i) {
                char c = string2.charAt(i);
                if (c >= 'a' && c <= 'z') continue;
                bl = false;
                break;
            }
            if (bl) {
                super.insertString(n, string2, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

