/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.login;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.gui.NumberDocumentFilter;
import games.stendhal.client.gui.ProgressBar;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.login.Profile;
import games.stendhal.client.gui.login.ProfileList;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.stendhal;
import games.stendhal.client.update.ClientGameConfiguration;
import games.stendhal.common.MathHelper;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import marauroa.client.BannedAddressException;
import marauroa.client.LoginFailedException;
import marauroa.client.TimeoutException;
import marauroa.common.io.Persistence;
import marauroa.common.net.InvalidVersionException;
import marauroa.common.net.message.MessageS2CLoginNACK;
import org.apache.log4j.Logger;

public class LoginDialog
extends JDialog {
    private static final String SELECTED_PROFILE_PROPERTY = "ui.window.login.profile";
    private ProfileList profiles;
    private JComboBox<Profile> profilesComboBox;
    private JCheckBox saveLoginBox;
    private JCheckBox savePasswordBox;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JTextField serverField;
    private JTextField serverPortField;
    private JButton loginButton;
    private JButton removeButton;
    private final StendhalClient client;
    private ProgressBar progressBar;
    private DataValidator fieldValidator;

    public LoginDialog(Frame frame, StendhalClient stendhalClient) {
        super(frame, true);
        this.client = stendhalClient;
        this.initializeComponent();
        WindowUtils.closeOnEscape(this);
    }

    private void initializeComponent() {
        this.setDefaultCloseOperation(2);
        if (this.getOwner() != null) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    LoginDialog.this.getOwner().setEnabled(true);
                }
            });
        }
        this.setTitle("Login to Server");
        this.setResizable(false);
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new GridBagLayout());
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        JLabel jLabel = new JLabel("Account profiles");
        gridBagConstraints.insets = new Insets(4, 4, 15, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jComponent.add((Component)jLabel, gridBagConstraints);
        this.profilesComboBox = new JComboBox();
        this.profilesComboBox.addActionListener(new ProfilesCB());
        this.removeButton = this.createRemoveButton();
        JComponent jComponent2 = SBoxLayout.createContainer(true, 5);
        this.profilesComboBox.setAlignmentY(0.5f);
        jComponent2.add(this.profilesComboBox);
        jComponent2.add(this.removeButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        jComponent.add((Component)jComponent2, gridBagConstraints);
        jLabel = new JLabel("Server name");
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jComponent.add((Component)jLabel, gridBagConstraints);
        this.serverField = new JTextField(ClientGameConfiguration.get((String)"DEFAULT_SERVER"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        jComponent.add((Component)this.serverField, gridBagConstraints);
        jLabel = new JLabel("Server port");
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jComponent.add((Component)jLabel, gridBagConstraints);
        this.serverPortField = new JTextField(ClientGameConfiguration.get((String)"DEFAULT_PORT"));
        ((AbstractDocument)this.serverPortField.getDocument()).setDocumentFilter(new NumberDocumentFilter(this.serverPortField, false));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 1;
        jComponent.add((Component)this.serverPortField, gridBagConstraints);
        jLabel = new JLabel("Type your username");
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jComponent.add((Component)jLabel, gridBagConstraints);
        this.usernameField = new JTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        jComponent.add((Component)this.usernameField, gridBagConstraints);
        jLabel = new JLabel("Type your password");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        jComponent.add((Component)jLabel, gridBagConstraints);
        this.passwordField = new JPasswordField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        jComponent.add((Component)this.passwordField, gridBagConstraints);
        this.saveLoginBox = new JCheckBox("Save login profile locally");
        this.saveLoginBox.setSelected(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        jComponent.add((Component)this.saveLoginBox, gridBagConstraints);
        this.savePasswordBox = new JCheckBox("Save password");
        this.savePasswordBox.setSelected(true);
        this.savePasswordBox.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jComponent.add((Component)this.savePasswordBox, gridBagConstraints);
        this.loginButton = new JButton();
        this.loginButton.setText("Login to Server");
        this.loginButton.setMnemonic(76);
        this.rootPane.setDefaultButton(this.loginButton);
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.loginButtonActionPerformed();
            }
        });
        JComponent jComponent3 = SBoxLayout.createContainer(true, 5);
        JButton jButton = new JButton("Cancel");
        jButton.setMnemonic(67);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.dispatchEvent(new WindowEvent(LoginDialog.this, 201));
            }
        });
        jComponent3.add(jButton);
        jComponent3.add(this.loginButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        jComponent.add((Component)jComponent3, gridBagConstraints);
        this.bindEditListener();
        this.profiles = this.loadProfiles();
        this.populateProfiles(this.profiles);
        this.saveLoginBox.addChangeListener(new SaveProfileStateCB());
        this.pack();
        this.usernameField.requestFocusInWindow();
        if (this.getOwner() != null) {
            this.getOwner().setEnabled(false);
            this.setLocationRelativeTo(this.getOwner());
        }
    }

    private void bindEditListener() {
        this.fieldValidator = new DataValidator(this.loginButton, this.serverField.getDocument(), this.serverPortField.getDocument(), this.usernameField.getDocument(), this.passwordField.getDocument());
    }

    private JButton createRemoveButton() {
        URL uRL = DataLoader.getResource("data/gui/trash.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        JButton jButton = new JButton(imageIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText("Remove the selected account from the list");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.removeButtonActionPerformed();
            }
        });
        return jButton;
    }

    private void loginButtonActionPerformed() {
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        this.setEnabled(false);
        Profile profile = new Profile();
        profile.setHost(this.serverField.getText().trim());
        try {
            profile.setPort(Integer.parseInt(this.serverPortField.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "That is not a valid port number. Please try again.", "Invalid port", 2);
            return;
        }
        profile.setUser(this.usernameField.getText().trim());
        profile.setPassword(new String(this.passwordField.getPassword()));
        if (this.saveLoginBox.isSelected()) {
            this.profiles.add(profile);
            this.populateProfiles(this.profiles);
            if (this.savePasswordBox.isSelected()) {
                this.saveProfiles(this.profiles);
            } else {
                object = profile.getPassword();
                profile.setPassword("");
                this.saveProfiles(this.profiles);
                profile.setPassword((String)object);
            }
        }
        this.setCurrentProfileAsDefault();
        object = new Thread((Runnable)new ConnectRunnable(profile), "Login");
        ((Thread)object).start();
    }

    private void removeButtonActionPerformed() {
        if (!this.isEnabled() || this.profiles.profiles.size() == 0) {
            return;
        }
        this.setEnabled(false);
        Profile profile = (Profile)this.profilesComboBox.getSelectedItem();
        Object[] objectArray = new Object[]{"Remove", "Cancel"};
        Integer n = JOptionPane.showOptionDialog(this, "This will permanently remove a user profile from your local list of accounts.\nIt will not delete an account on any servers.\nAre you sure you want to remove '" + profile.getUser() + "@" + profile.getHost() + "' profile?", "Remove user profile from local list of accounts", 2, 3, null, objectArray, objectArray[1]);
        if (n == 0) {
            this.profiles.remove(profile);
            this.saveProfiles(this.profiles);
            this.profiles = this.loadProfiles();
            this.populateProfiles(this.profiles);
            this.setCurrentProfileAsDefault();
        }
        this.setEnabled(true);
    }

    private void setCurrentProfileAsDefault() {
        int n = this.profilesComboBox.getSelectedIndex();
        if (n >= 0) {
            WtWindowManager.getInstance().setProperty(SELECTED_PROFILE_PROPERTY, String.valueOf(n));
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fieldValidator.revalidate();
        this.removeButton.setEnabled(bl);
    }

    public void connect(Profile profile) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoginDialog.this.progressBar = new ProgressBar(LoginDialog.this);
                LoginDialog.this.progressBar.start();
            }
        });
        try {
            this.client.connect(profile.getHost(), profile.getPort());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoginDialog.this.progressBar.step();
                }
            });
        }
        catch (Exception exception) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoginDialog.this.progressBar.cancel();
                    LoginDialog.this.setEnabled(true);
                }
            });
            String string = "unable to connect to server";
            string = profile != null ? string + " " + profile.getHost() + ":" + profile.getPort() : string + ", because profile was null";
            Logger.getLogger(LoginDialog.class).error((Object)string, (Throwable)exception);
            this.handleError("Unable to connect to server. Did you misspell the server name?", "Connection failed");
            return;
        }
        try {
            this.client.setAccountUsername(profile.getUser());
            this.client.setCharacter(profile.getCharacter());
            this.client.login(profile.getUser(), profile.getPassword(), profile.getSeed());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoginDialog.this.progressBar.finish();
                    try {
                        LoginDialog.this.setVisible(false);
                    }
                    catch (NullPointerException nullPointerException) {
                        Logger.getLogger(LoginDialog.class).error((Object)"Error probably related to bug in JRE occured", (Throwable)nullPointerException);
                        LoginDialog.this.dispose();
                    }
                }
            });
        }
        catch (InvalidVersionException invalidVersionException) {
            this.handleError("You are running an incompatible version of Stendhal. Please update", "Invalid version");
        }
        catch (TimeoutException timeoutException) {
            this.handleError("Server is not available right now.\nThe server may be down or, if you are using a custom server,\nyou may have entered its name and port number incorrectly.", "Error Logging In");
        }
        catch (LoginFailedException loginFailedException) {
            this.handleError(loginFailedException.getMessage(), "Login failed");
            if (loginFailedException.getReason() == MessageS2CLoginNACK.Reasons.SEED_WRONG) {
                System.exit(1);
            }
        }
        catch (BannedAddressException bannedAddressException) {
            this.handleError("Your IP is banned.", "IP Banned");
        }
    }

    private void handleError(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoginDialog.this.progressBar.cancel();
                JOptionPane.showMessageDialog(LoginDialog.this, string, string2, 0);
                if (LoginDialog.this.isVisible()) {
                    LoginDialog.this.setEnabled(true);
                } else {
                    System.exit(1);
                }
            }
        });
    }

    private ProfileList loadProfiles() {
        ProfileList profileList = new ProfileList();
        try (InputStream inputStream = Persistence.get().getInputStream(false, stendhal.getGameFolder(), "user.dat");){
            profileList.load(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "An error occurred while loading your login information", "Error Loading Login Information", 2);
        }
        return profileList;
    }

    private void populateProfiles(ProfileList profileList) {
        this.profilesComboBox.removeAllItems();
        for (Profile profile : profileList) {
            this.profilesComboBox.addItem(profile);
        }
        this.selectDefaultProfile();
    }

    private void selectDefaultProfile() {
        String string = WtWindowManager.getInstance().getProperty(SELECTED_PROFILE_PROPERTY, "-1");
        int n = MathHelper.parseIntDefault(string, -1);
        int n2 = this.profilesComboBox.getItemCount();
        if (n >= 0 && n < n2) {
            this.profilesComboBox.setSelectedIndex(n);
        } else if (n2 != 0) {
            this.profilesComboBox.setSelectedIndex(n2 - 1);
        }
    }

    private void profilesCB() {
        Profile profile = (Profile)this.profilesComboBox.getSelectedItem();
        if (profile != null) {
            String string = profile.getHost();
            this.serverField.setText(string);
            this.serverPortField.setText(String.valueOf(profile.getPort()));
            this.usernameField.setText(profile.getUser());
            this.passwordField.setText(profile.getPassword());
        } else {
            this.serverPortField.setText(String.valueOf(32160));
            this.usernameField.setText("");
            this.passwordField.setText("");
        }
    }

    private void saveProfiles(ProfileList profileList) {
        try (OutputStream outputStream = Persistence.get().getOutputStream(false, stendhal.getGameFolder(), "user.dat");){
            profileList.save(outputStream);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "An error occurred while saving your login information", "Error Saving Login Information", 2);
        }
    }

    private void saveProfileStateCB() {
        this.savePasswordBox.setEnabled(this.saveLoginBox.isSelected());
    }

    private class SaveProfileStateCB
    implements ChangeListener {
        private SaveProfileStateCB() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            LoginDialog.this.saveProfileStateCB();
        }
    }

    private class ProfilesCB
    implements ActionListener {
        private ProfilesCB() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LoginDialog.this.profilesCB();
        }
    }

    private final class ConnectRunnable
    implements Runnable {
        private final Profile profile;

        private ConnectRunnable(Profile profile) {
            this.profile = profile;
        }

        @Override
        public void run() {
            LoginDialog.this.connect(this.profile);
        }
    }

    private static class DataValidator
    implements DocumentListener {
        private final Document[] documents;
        private final JComponent component;

        DataValidator(JComponent jComponent, Document ... documentArray) {
            this.component = jComponent;
            this.documents = documentArray;
            for (Document document : documentArray) {
                document.addDocumentListener(this);
            }
            this.revalidate();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.revalidate();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument().getLength() == 0) {
                this.component.setEnabled(false);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        final void revalidate() {
            for (Document document : this.documents) {
                if (document.getLength() != 0) continue;
                this.component.setEnabled(false);
                return;
            }
            this.component.setEnabled(true);
        }
    }
}

