/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.settings;

import games.stendhal.client.actions.MoveContinuousAction;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.settings.SettingsComponentFactory;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.wt.core.SettingChangeListener;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;

class GeneralSettings {
    private static final String GAMESCREEN_AUTORAISECORPSE = "gamescreen.autoinspectcorpses";
    private static final String DOUBLE_CLICK_PROPERTY = "ui.doubleclick";
    private static final String HEALING_MESSAGE_PROPERTY = "ui.healingmessage";
    private static final String POISON_MESSAGE_PROPERTY = "ui.poisonmessage";
    private static final String DIMENSIONS_PROPERTY = "ui.dimensions";
    private final JComponent page;

    GeneralSettings() {
        int n = 5;
        this.page = SBoxLayout.createContainer(false, n);
        this.page.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        JCheckBox jCheckBox = SettingsComponentFactory.createSettingsToggle(DOUBLE_CLICK_PROPERTY, false, "Double Click Mode", "Move and attack with double click. If not checked, a single click is enough.");
        this.page.add(jCheckBox);
        JCheckBox jCheckBox2 = SettingsComponentFactory.createSettingsToggle(GAMESCREEN_AUTORAISECORPSE, true, "Auto inspect corpses", "Automatically open the loot window for corpses of creatures you can loot");
        this.page.add(jCheckBox2);
        JCheckBox jCheckBox3 = SettingsComponentFactory.createSettingsToggle(HEALING_MESSAGE_PROPERTY, false, "Show healing messages", "Show healing messages in the chat log");
        this.page.add(jCheckBox3);
        JCheckBox jCheckBox4 = SettingsComponentFactory.createSettingsToggle(POISON_MESSAGE_PROPERTY, false, "Show poison messages", "Show poisoned messages in the chat log");
        this.page.add(jCheckBox4);
        JCheckBox jCheckBox5 = SettingsComponentFactory.createSettingsToggle("move.doubletapautowalk", false, "Double-tap direction for auto-walk (experimental)", "Initiates auto-walk when direction key is double-tapped");
        this.page.add(jCheckBox5);
        final JCheckBox jCheckBox6 = SettingsComponentFactory.createSettingsToggle("move.continuous", false, "Continuous movement", "Change maps and pass through portals without stopping");
        jCheckBox6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new MoveContinuousAction().sendAction(jCheckBox6.isSelected());
            }
        });
        WtWindowManager.getInstance().registerSettingChangeListener("move.continuous", new SettingChangeListener(){

            @Override
            public void changed(String string) {
                jCheckBox6.setSelected(Boolean.parseBoolean(string));
            }
        });
        this.page.add(jCheckBox6);
        JCheckBox jCheckBox7 = SettingsComponentFactory.createSettingsToggle("ui.msg_blink", true, "Blink on channel message", "Chat channel tab blinks on message when not focused");
        this.page.add(jCheckBox7);
        JCheckBox jCheckBox8 = SettingsComponentFactory.createSettingsToggle("ui.msg_sound", true, "Personal message audio notification", "Play sound for personal messages channel when not focused");
        this.page.add(jCheckBox8);
        JComponent jComponent = SBoxLayout.createContainer(false, n);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Client Dimensions");
        Style style = StyleUtil.getStyle();
        if (style != null) {
            jComponent.setBackground(style.getPlainColor());
            titledBorder.setTitleColor(style.getForeground());
        }
        jComponent.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(n, n, n, n)));
        JCheckBox jCheckBox9 = SettingsComponentFactory.createSettingsToggle(DIMENSIONS_PROPERTY, true, "Save size", "Restores the client's width, height, and maximized state in future sessions");
        jComponent.add(jCheckBox9);
        JButton jButton = new JButton("Reset");
        jButton.setToolTipText("Resets the client's width and height to their default dimensions");
        jButton.setActionCommand("reset_dimensions");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralSettings.this.resetClientDimensions();
            }
        });
        jButton.setAlignmentX(1.0f);
        jComponent.add(jButton);
        this.page.add((Component)jComponent, (Object)SLayout.EXPAND_X);
    }

    JComponent getComponent() {
        return this.page;
    }

    private void resetClientDimensions() {
        j2DClient j2DClient2 = j2DClient.get();
        j2DClient2.resetClientDimensions();
    }
}

