/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.settings;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.common.NotificationType;
import games.stendhal.common.math.Numeric;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SoundSettings {
    private static final String SOUND_PROPERTY = "sound.play";
    private static final String VOLUME_PROPERTY = "sound.volume.";
    private static final String DEVICE_PROPERTY = "sound.device";
    private static final String DEFAULT_DEVICE = "auto - recommended";
    private final JComponent page;
    private List<JComponent> sliderComponents = new ArrayList<JComponent>(14);

    SoundSettings() {
        int n = 5;
        this.page = SBoxLayout.createContainer(false, n);
        this.page.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        JCheckBox jCheckBox = new JCheckBox("Play Sounds");
        boolean bl = WtWindowManager.getInstance().getPropertyBoolean(SOUND_PROPERTY, true);
        jCheckBox.setSelected(bl);
        jCheckBox.addItemListener(new MuteListener());
        this.page.add(jCheckBox);
        JComponent jComponent = SBoxLayout.createContainer(true, n);
        JLabel jLabel = new JLabel("Sound device:");
        jComponent.add(jLabel);
        JComponent jComponent2 = this.createDeviceSelector();
        jComponent.add(jComponent2);
        jComponent2.setToolTipText("<html>Sound output device. <b>auto</b> should work for most people,<br>but try others if you can not get sound to work otherwise</html>");
        this.sliderComponents.add(jLabel);
        this.sliderComponents.add(jComponent2);
        this.page.add(jComponent);
        JComponent jComponent3 = SBoxLayout.createContainer(true, n);
        this.page.add((Component)jComponent3, (Object)SLayout.EXPAND_X);
        JLabel jLabel2 = new JLabel("Master");
        jComponent3.add(jLabel2);
        SBoxLayout.addSpring(jComponent3);
        JSlider jSlider = this.createMasterVolumeSlider();
        jSlider.setToolTipText("Volume of all sound channels");
        jComponent3.add(jSlider);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider);
        jComponent3 = SBoxLayout.createContainer(true, n);
        this.page.add((Component)jComponent3, (Object)SLayout.EXPAND_X);
        jLabel2 = new JLabel("GUI");
        jComponent3.add(jLabel2);
        SBoxLayout.addSpring(jComponent3);
        JSlider jSlider2 = this.createVolumeSlider("gui");
        jSlider2.setToolTipText("Volume of interactive operations, such as closing windows");
        jComponent3.add(jSlider2);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider2);
        jComponent3 = SBoxLayout.createContainer(true, n);
        this.page.add((Component)jComponent3, (Object)SLayout.EXPAND_X);
        jLabel2 = new JLabel("Effects");
        jComponent3.add(jLabel2);
        SBoxLayout.addSpring(jComponent3);
        JSlider jSlider3 = this.createVolumeSlider("sfx");
        jSlider3.setToolTipText("Volume of fighting, and other effects");
        jComponent3.add(jSlider3);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider3);
        jComponent3 = SBoxLayout.createContainer(true, n);
        this.page.add((Component)jComponent3, (Object)SLayout.EXPAND_X);
        jLabel2 = new JLabel("Creatures");
        jComponent3.add(jLabel2);
        SBoxLayout.addSpring(jComponent3);
        JSlider jSlider4 = this.createVolumeSlider("creature");
        jSlider4.setToolTipText("Volume of creature noises");
        jComponent3.add(jSlider4);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider4);
        jComponent3 = SBoxLayout.createContainer(true, n);
        this.page.add((Component)jComponent3, (Object)SLayout.EXPAND_X);
        jLabel2 = new JLabel("Ambient");
        jComponent3.add(jLabel2);
        SBoxLayout.addSpring(jComponent3);
        JSlider jSlider5 = this.createVolumeSlider("ambient");
        jComponent3.add(jSlider5);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider5);
        jComponent3 = SBoxLayout.createContainer(true, n);
        this.page.add((Component)jComponent3, (Object)SLayout.EXPAND_X);
        jLabel2 = new JLabel("Music");
        jComponent3.add(jLabel2);
        SBoxLayout.addSpring(jComponent3);
        JSlider jSlider6 = this.createVolumeSlider("music");
        jSlider6.setToolTipText("Music volume");
        jComponent3.add(jSlider6);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider6);
        for (JComponent jComponent4 : this.sliderComponents) {
            jComponent4.setEnabled(bl);
        }
    }

    JComponent getComponent() {
        return this.page;
    }

    private JComponent createDeviceSelector() {
        String string2;
        final JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(DEFAULT_DEVICE);
        for (String string2 : ClientSingletonRepository.getSound().getDeviceNames()) {
            jComboBox.addItem(string2);
        }
        final WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        string2 = wtWindowManager.getProperty(DEVICE_PROPERTY, DEFAULT_DEVICE);
        jComboBox.setSelectedItem(string2);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                wtWindowManager.setProperty(SoundSettings.DEVICE_PROPERTY, object != null ? object.toString() : SoundSettings.DEFAULT_DEVICE);
                wtWindowManager.save();
                String string = "Changing the sound device will take effect when you next time restart the game.";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string, NotificationType.CLIENT));
            }
        });
        return jComboBox;
    }

    private JSlider createMasterVolumeSlider() {
        JSlider jSlider = new JSlider(0, 100);
        float f = ClientSingletonRepository.getSound().getVolume();
        jSlider.setValue(Numeric.floatToInt(f, 100.0f));
        jSlider.addChangeListener(new MasterVolumeListener());
        return jSlider;
    }

    private JSlider createVolumeSlider(String string) {
        JSlider jSlider = new JSlider(0, 100);
        SoundGroup soundGroup = ClientSingletonRepository.getSound().getGroup(string);
        jSlider.setValue(Numeric.floatToInt(soundGroup.getVolume(), 100.0f));
        jSlider.addChangeListener(new ChannelChangeListener(string, soundGroup));
        return jSlider;
    }

    private static class ChannelChangeListener
    implements ChangeListener {
        private final SoundGroup group;
        private final String groupName;

        public ChannelChangeListener(String string, SoundGroup soundGroup) {
            this.group = soundGroup;
            this.groupName = string;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            this.group.changeVolume(Numeric.intToFloat(n, 100.0f));
            WtWindowManager.getInstance().setProperty(SoundSettings.VOLUME_PROPERTY + this.groupName, Integer.toString(n));
        }
    }

    private static class MasterVolumeListener
    implements ChangeListener {
        private MasterVolumeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            ClientSingletonRepository.getSound().changeVolume(Numeric.intToFloat(n, 100.0f));
            WtWindowManager.getInstance().setProperty("sound.volume.master", Integer.toString(n));
        }
    }

    private class MuteListener
    implements ItemListener {
        private MuteListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            WtWindowManager.getInstance().setProperty(SoundSettings.SOUND_PROPERTY, Boolean.toString(bl));
            ClientSingletonRepository.getSound().mute(!bl, true, new Time(2L, Time.Unit.SEC));
            for (JComponent jComponent : SoundSettings.this.sliderComponents) {
                jComponent.setEnabled(bl);
            }
        }
    }
}

