/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.stats;

import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.Timer;

class AnimatedIcon
extends JComponent {
    private final Sprite[] sprite;
    private final Timer timer;
    private int current = 0;
    private final ActionListener timerTask = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AnimatedIcon.this.current++;
            if (AnimatedIcon.this.current >= AnimatedIcon.this.sprite.length) {
                AnimatedIcon.this.current = 0;
            }
            AnimatedIcon.this.repaint();
        }
    };

    AnimatedIcon(Sprite sprite, int n) {
        this.setOpaque(false);
        int n2 = sprite.getHeight();
        int n3 = sprite.getWidth() / n2;
        this.sprite = new Sprite[n3];
        this.timer = new Timer(n, this.timerTask);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        SpriteStore spriteStore = SpriteStore.get();
        for (int i = 0; i < n3; ++i) {
            this.sprite[i] = spriteStore.getTile(sprite, i * n2, 0, n2, n2);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.sprite[0].getWidth() + insets.left + insets.right, this.sprite[0].getHeight() + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        this.sprite[this.current].draw(graphics, insets.left, insets.top);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }
}

