/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxUI;

public class StyledCheckBoxUI
extends BasicCheckBoxUI {
    private static final int ICON_WIDTH = 14;
    private static StyledCheckBoxUI instance;
    private final Style style;
    private Icon defaultIcon;
    private Icon defaultSelectedIcon;
    private Icon disabledIcon;
    private Icon disabledSelectedIcon;

    public static synchronized ComponentUI createUI(JComponent jComponent) {
        if (instance == null) {
            instance = new StyledCheckBoxUI(StyleUtil.getStyle());
        }
        return instance;
    }

    public StyledCheckBoxUI(Style style) {
        this.style = style;
        this.createIcons();
    }

    @Override
    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        if (abstractButton.isEnabled()) {
            super.paintText(graphics, abstractButton, rectangle, string);
        } else {
            int n = graphics.getFontMetrics().getAscent();
            StyleUtil.paintDisabledText(this.style, graphics, string, rectangle.x, rectangle.y + n);
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setForeground(this.style.getForeground());
        jComponent.setOpaque(false);
        jComponent.setFont(this.style.getFont().deriveFont(1));
        if (jComponent instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)jComponent;
            jCheckBox.setIcon(this.defaultIcon);
            jCheckBox.setSelectedIcon(this.defaultSelectedIcon);
            jCheckBox.setDisabledIcon(this.disabledIcon);
            jCheckBox.setDisabledSelectedIcon(this.disabledSelectedIcon);
        }
    }

    private void createIcons() {
        Border border = this.style.getBorderDown();
        Insets insets = border.getBorderInsets(null);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(14, 14, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(this.style.getForeground());
        graphics2D.fillRect(0, 0, 14, 14);
        graphics2D.setClip(0, 0, 14, 14);
        border.paintBorder(null, graphics2D, 0, 0, 14, 14);
        graphics2D.dispose();
        this.defaultIcon = new ImageIcon(bufferedImage);
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(14, 14, 1);
        graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        BasicStroke basicStroke = new BasicStroke(2.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(this.style.getShadowColor());
        this.drawTick(graphics2D, insets);
        graphics2D.dispose();
        this.defaultSelectedIcon = new ImageIcon(bufferedImage2);
        bufferedImage2 = graphicsConfiguration.createCompatibleImage(14, 14, 1);
        graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(this.style.getShadowColor());
        graphics2D.fillRect(0, 0, 14, 14);
        graphics2D.setClip(0, 0, 14, 14);
        border.paintBorder(null, graphics2D, 0, 0, 14, 14);
        graphics2D.dispose();
        this.disabledIcon = new ImageIcon(bufferedImage2);
        bufferedImage = graphicsConfiguration.createCompatibleImage(14, 14, 1);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(this.style.getHighLightColor());
        this.drawTick(graphics2D, insets);
        graphics2D.dispose();
        this.disabledSelectedIcon = new ImageIcon(bufferedImage);
    }

    private void drawTick(Graphics graphics, Insets insets) {
        graphics.drawLine(insets.left + 2, 7, insets.left + 4, 14 - insets.bottom - 2);
        graphics.drawLine(14 - insets.right - 2, 4, insets.left + 4, 14 - insets.bottom - 2);
    }
}

