/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.styled.StyledArrowButton;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class StyledSpinnerUI
extends BasicSpinnerUI {
    private final Style style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new StyledSpinnerUI(StyleUtil.getStyle());
    }

    public StyledSpinnerUI(Style style) {
        this.style = style;
    }

    @Override
    protected JComponent createEditor() {
        JComponent jComponent = super.createEditor();
        jComponent.setBorder(this.style.getBorderDown());
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setBorder(null);
        }
        return jComponent;
    }

    @Override
    protected Component createNextButton() {
        StyledArrowButton styledArrowButton = new StyledArrowButton(1, this.style);
        this.installNextButtonListeners(styledArrowButton);
        return styledArrowButton;
    }

    @Override
    protected Component createPreviousButton() {
        StyledArrowButton styledArrowButton = new StyledArrowButton(5, this.style);
        this.installPreviousButtonListeners(styledArrowButton);
        return styledArrowButton;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(null);
    }
}

