/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class StyledSplitPaneUI
extends BasicSplitPaneUI {
    private final Style style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new StyledSplitPaneUI(StyleUtil.getStyle());
    }

    public StyledSplitPaneUI(Style style) {
        this.style = style;
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new StyledSplitPaneDivider(this, this.style);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(this.style.getBorderDown());
    }

    @Override
    public int getMaximumDividerLocation(JSplitPane jSplitPane) {
        int n = super.getMaximumDividerLocation(jSplitPane);
        Component component = jSplitPane.getLeftComponent();
        if (component != null && component.isVisible()) {
            Dimension dimension = component.getMaximumSize();
            Insets insets = jSplitPane.getInsets();
            n = jSplitPane.getOrientation() == 1 ? Math.min(n, dimension.width + insets.left) : Math.min(n, dimension.height + insets.top);
            n = Math.max(n, this.getMinimumDividerLocation(jSplitPane));
        }
        return n;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.getSplitPane().getOrientation() == 1) {
            dimension.width -= this.getSplitPane().getDividerSize();
        } else {
            dimension.height -= this.getSplitPane().getDividerSize();
        }
        return dimension;
    }

    @Override
    public int getMinimumDividerLocation(JSplitPane jSplitPane) {
        int n = super.getMinimumDividerLocation(jSplitPane);
        Component component = jSplitPane.getRightComponent();
        if (component != null && component.isVisible()) {
            Dimension dimension = this.splitPane.getSize();
            Dimension dimension2 = component.getMaximumSize();
            Insets insets = jSplitPane.getInsets();
            n = jSplitPane.getOrientation() == 1 ? Math.max(n, dimension.width - insets.right - dimension2.width) : Math.max(n, dimension.height - insets.bottom - dimension2.height);
        }
        return n;
    }

    @Override
    public void setDividerLocation(JSplitPane jSplitPane, int n) {
        int n2 = Math.min(n, this.getMaximumDividerLocation(jSplitPane));
        if ((n2 = Math.max(n2, this.getMinimumDividerLocation(jSplitPane))) != n) {
            jSplitPane.setDividerLocation(n2);
        } else {
            super.setDividerLocation(jSplitPane, n);
        }
        final int n3 = n2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StyledSplitPaneUI.this.getSplitPane().setLastDividerLocation(n3);
            }
        });
    }

    @Override
    protected void dragDividerTo(int n) {
        n = Math.min(n, this.getMaximumDividerLocation(this.getSplitPane()));
        n = Math.max(n, this.getMinimumDividerLocation(this.getSplitPane()));
        super.dragDividerTo(n);
    }

    private static class StyledSplitPaneDivider
    extends BasicSplitPaneDivider {
        private static final long serialVersionUID = 3799692779880585757L;
        private final Style style;

        public StyledSplitPaneDivider(StyledSplitPaneUI styledSplitPaneUI, Style style) {
            super(styledSplitPaneUI);
            this.style = style;
            this.addMouseListener(new DividerMouseListener(this));
        }

        @Override
        public void paint(Graphics graphics) {
            StyleUtil.fillBackground(this.style, graphics, 0, 0, this.getWidth(), this.getHeight());
            Insets insets = this.style.getBorder().getBorderInsets(this);
            if (this.splitPane.getOrientation() == 0) {
                int n = this.getHeight() - insets.bottom - 1;
                for (int i = insets.top + 1; i < n; ++i) {
                    graphics.setColor(this.style.getShadowColor());
                    graphics.drawLine(5, i, this.getWidth() - 6, i);
                    graphics.setColor(this.style.getHighLightColor());
                    graphics.drawLine(5, ++i, this.getWidth() - 6, i);
                }
            } else {
                int n = this.getWidth() - insets.right - 1;
                for (int i = insets.left + 1; i < n; ++i) {
                    graphics.setColor(this.style.getShadowColor());
                    graphics.drawLine(i, 5, i, this.getHeight() - 6);
                    graphics.setColor(this.style.getHighLightColor());
                    graphics.drawLine(++i, 5, i, this.getHeight() - 6);
                }
            }
            if (this.isMouseOver()) {
                this.highLightBorder(graphics);
            } else {
                this.paintBorder(graphics);
            }
        }

        private void paintBorder(Graphics graphics) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Border border = this.style.getBorder();
            if (this.orientation == 1) {
                n3 = border.getBorderInsets((Component)this).top;
                n4 = border.getBorderInsets((Component)this).bottom;
            } else {
                n = border.getBorderInsets((Component)this).left;
                n2 = border.getBorderInsets((Component)this).right;
            }
            border.paintBorder(this, graphics, 0 - n, 0 - n3, this.getWidth() + n2 + n, this.getHeight() + n3 + n4);
        }

        private void highLightBorder(Graphics graphics) {
            graphics.setColor(this.style.getHighLightColor());
            Border border = this.style.getBorder();
            if (this.orientation == 1) {
                int n = border.getBorderInsets((Component)this).left;
                graphics.fillRect(0, 0, n, this.getHeight());
                graphics.fillRect(this.getWidth() - n, 0, n, this.getHeight());
            } else {
                int n = border.getBorderInsets((Component)this).top;
                graphics.fillRect(0, 0, this.getWidth(), n);
                graphics.fillRect(0, this.getHeight() - n, this.getWidth(), n);
            }
        }

        private static class DividerMouseListener
        extends MouseAdapter {
            private final StyledSplitPaneDivider divider;

            public DividerMouseListener(StyledSplitPaneDivider styledSplitPaneDivider) {
                this.divider = styledSplitPaneDivider;
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.divider.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.divider.repaint();
            }
        }
    }
}

