/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class StyledToolTipUI
extends BasicToolTipUI {
    private static StyledToolTipUI instance;
    private final Style style;
    private final Border border;

    public static synchronized ComponentUI createUI(JComponent jComponent) {
        if (instance == null) {
            instance = new StyledToolTipUI(StyleUtil.getStyle());
        }
        return instance;
    }

    public StyledToolTipUI(Style style) {
        this.style = style;
        this.border = BorderFactory.createLineBorder(style.getShadowColor());
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        JComponent jComponent2;
        Container container = jComponent.getParent();
        if (container instanceof JComponent && (jComponent2 = (JComponent)container).getBorder() != null) {
            jComponent2.setBorder(null);
        }
        super.paint(graphics, jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBackground(this.style.getHighLightColor());
        jComponent.setForeground(this.style.getShadowColor());
        jComponent.setBorder(this.border);
    }
}

