/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled.styles;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.styles.PixmapStyle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import org.apache.log4j.Logger;

public class StyleFactory {
    private static final Logger logger = Logger.getLogger(StyleFactory.class);

    public static Style createStyle(String string) {
        StyleDefinition styleDefinition = StyleDefinition.parse(string);
        return styleDefinition.create();
    }

    public static Collection<String> getAvailableStyles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StyleDefinition styleDefinition : StyleDefinition.values()) {
            arrayList.add(styleDefinition.toString());
        }
        return arrayList;
    }

    private static enum StyleDefinition {
        WOOD("Wood (default)"){

            @Override
            Style create() {
                return new PixmapStyle("data/gui/panel_wood_v.png", true, new Color(163, 120, 97), new Color(50, 25, 12), new Color(107, 72, 50), Color.white);
            }
        }
        ,
        WOOD2("Wood 2"){

            @Override
            Style create() {
                return new PixmapStyle("data/gui/panel_wood_h.png", true, new Color(163, 120, 97), new Color(50, 25, 12), new Color(107, 72, 50), Color.white);
            }
        }
        ,
        AUBERGINE("Aubergine"){

            @Override
            Style create() {
                Color color = new Color(184, 149, 193);
                Color color2 = new Color(42, 7, 51);
                PixmapStyle pixmapStyle = new PixmapStyle("data/gui/panel_aubergine.png", false, color, color2, Color.white, Color.white);
                Color color3 = new Color(119, 74, 130);
                Color color4 = new Color(84, 42, 95);
                Color color5 = new Color(37, 1, 46);
                pixmapStyle.setBorder(BorderFactory.createBevelBorder(0, color3, color, color5, color4));
                pixmapStyle.setBorderDown(BorderFactory.createBevelBorder(1, color3, color, color5, color4));
                return pixmapStyle;
            }
        }
        ,
        BRICK_BROWN("Brick Brown"){

            @Override
            Style create() {
                Color color = new Color(219, 191, 130);
                Color color2 = new Color(36, 14, 0);
                PixmapStyle pixmapStyle = new PixmapStyle("data/gui/panel_brick.png", false, color, color2, Color.white, Color.white);
                Color color3 = new Color(181, 140, 50);
                Color color4 = new Color(98, 47, 15);
                pixmapStyle.setBorder(BorderFactory.createBevelBorder(0, color, color3, color2, color4));
                pixmapStyle.setBorderDown(BorderFactory.createBevelBorder(1, color, color3, color2, color4));
                return pixmapStyle;
            }
        }
        ,
        HONEYCOMB("Honeycomb"){

            @Override
            Style create() {
                Color color = new Color(184, 142, 64);
                Color color2 = new Color(39, 26, 4);
                Color color3 = new Color(129, 104, 58);
                PixmapStyle pixmapStyle = new PixmapStyle("data/gui/panel_honeycomb.png", false, color, color2, color3, Color.white);
                Color color4 = new Color(255, 255, 180);
                Color color5 = new Color(202, 202, 101);
                Color color6 = new Color(160, 128, 32);
                Color color7 = new Color(86, 69, 17);
                pixmapStyle.setBorder(BorderFactory.createBevelBorder(0, color4, color5, color7, color6));
                pixmapStyle.setBorderDown(BorderFactory.createBevelBorder(1, color4, color5, color6, color7));
                return pixmapStyle;
            }
        }
        ,
        LEATHER_BLACK("Leather Black"){

            @Override
            Style create() {
                Color color = Color.white;
                Color color2 = new Color(130, 130, 130);
                PixmapStyle pixmapStyle = new PixmapStyle("data/gui/panel_leather.png", false, color2, Color.black, Color.white, color);
                Color color3 = new Color(120, 120, 120);
                Color color4 = new Color(80, 80, 80);
                Color color5 = new Color(40, 40, 40);
                pixmapStyle.setBorder(BorderFactory.createBevelBorder(0, color3, color4, Color.black, color5));
                pixmapStyle.setBorderDown(BorderFactory.createBevelBorder(1, color3, color4, color5, Color.black));
                return pixmapStyle;
            }
        }
        ,
        PARQUET_BROWN("Parquet Brown"){

            @Override
            Style create() {
                Color color = new Color(59, 25, 0);
                Color color2 = new Color(225, 173, 110);
                PixmapStyle pixmapStyle = new PixmapStyle("data/gui/panel_wood_parquet.png", false, color, color2, Color.white, Color.white);
                pixmapStyle.setBorder(BorderFactory.createBevelBorder(0, Color.white, color2, color, Color.black));
                pixmapStyle.setBorderDown(BorderFactory.createBevelBorder(1, Color.white, color2, color, Color.black));
                return pixmapStyle;
            }
        }
        ,
        STONE("Stone"){

            @Override
            Style create() {
                Color color = new Color(50, 50, 50);
                Color color2 = new Color(175, 175, 175);
                PixmapStyle pixmapStyle = new PixmapStyle("data/gui/panel_stone.png", false, color, color2, Color.white, Color.white);
                Color color3 = new Color(130, 130, 130);
                Color color4 = new Color(100, 100, 100);
                Color color5 = new Color(20, 20, 20);
                pixmapStyle.setBorder(BorderFactory.createBevelBorder(0, color3, color4, color, color5));
                pixmapStyle.setBorderDown(BorderFactory.createBevelBorder(1, color3, color4, color, color5));
                return pixmapStyle;
            }
        }
        ,
        TILE_AQUA("Tile Aqua"){

            @Override
            Style create() {
                Color color = new Color(137, 157, 157);
                PixmapStyle pixmapStyle = new PixmapStyle("data/gui/panel_aqua_tile.png", false, color, Color.black, Color.white, Color.white);
                Color color2 = new Color(187, 240, 240);
                Color color3 = new Color(23, 71, 71);
                Color color4 = new Color(16, 36, 36);
                pixmapStyle.setBorder(BorderFactory.createBevelBorder(0, color, color2, color4, color3));
                pixmapStyle.setBorderDown(BorderFactory.createBevelBorder(1, color, color2, color4, color3));
                return pixmapStyle;
            }
        }
        ,
        METAL("Metal"){

            @Override
            Style create() {
                PixmapStyle pixmapStyle = new PixmapStyle("data/gui/panel_metal.png", true, new Color(120, 160, 120), new Color(30, 60, 30), new Color(126, 126, 126), Color.white);
                return pixmapStyle;
            }
        };

        private final String name;

        abstract Style create();

        private StyleDefinition(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        static StyleDefinition parse(String string) {
            for (StyleDefinition styleDefinition : StyleDefinition.values()) {
                if (!styleDefinition.toString().equals(string)) continue;
                return styleDefinition;
            }
            logger.warn((Object)("Style '" + string + "'not found. Using the default."));
            return WOOD;
        }
    }
}

