/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.textformat;

import games.stendhal.client.gui.textformat.AttributedTextSink;
import games.stendhal.client.gui.textformat.FormatSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StringFormatter<K, T extends FormatSet<K, T>> {
    private static final Collection<Character> endMarkers = Arrays.asList(Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?'));
    private final Map<Character, T> coloringModes = new HashMap<Character, T>();

    public void addStyle(Character c, T t) {
        this.coloringModes.put(c, t);
    }

    public void format(String string, T t, AttributedTextSink<T> attributedTextSink) {
        BaseState baseState = new BaseState(this, attributedTextSink, t, string, 0);
        baseState.parse();
    }

    private class QuoteState
    extends AbstractParserState {
        final /* synthetic */ StringFormatter this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        QuoteState(AttributedTextSink<T> attributedTextSink, T t, String string, int n2) {
            this.this$0 = (StringFormatter)n;
            super((StringFormatter)n, attributedTextSink, t, string, n2);
        }

        @Override
        int parse() {
            ++this.index;
            this.push();
            return this.index;
        }
    }

    private class ColoringState
    extends BaseState {
        private boolean forceEndAtQuote;
        final /* synthetic */ StringFormatter this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        ColoringState(AttributedTextSink<T> attributedTextSink, T t, String string, int n2) {
            this.this$0 = (StringFormatter)n;
            super((StringFormatter)n, attributedTextSink, t, string, n2);
            this.checkFirst();
        }

        private void checkFirst() {
            char c;
            if (this.index < this.string.length() && (c = this.string.charAt(this.index)) == '\'') {
                this.endAtQuote = true;
                ++this.index;
                this.beginIndex = this.index;
            }
        }

        @Override
        boolean readNext() {
            char c = this.string.charAt(this.index);
            if (c == '\'') {
                if (this.endAtQuote || this.forceEndAtQuote) {
                    this.push();
                    if (this.endAtQuote) {
                        ++this.index;
                    }
                    return false;
                }
            } else if (!this.endAtQuote && endMarkers.contains(Character.valueOf(c)) && (Character.isWhitespace(c) || Character.isWhitespace(this.peekNext()))) {
                this.push();
                return false;
            }
            if (this.index >= this.string.length()) {
                return false;
            }
            super.readNext();
            return true;
        }

        void setForceEndAtQuote() {
            this.forceEndAtQuote = true;
        }

        private char peekNext() {
            int n = this.index + 1;
            if (n < this.string.length()) {
                return this.string.charAt(n);
            }
            return ' ';
        }
    }

    private class BaseState
    extends AbstractParserState {
        private char ignoreChar;
        boolean endAtQuote;
        final /* synthetic */ StringFormatter this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        BaseState(AttributedTextSink<T> attributedTextSink, T t, String string, int n2) {
            this.this$0 = (StringFormatter)n;
            super((StringFormatter)n, attributedTextSink, t, string, n2);
            this.ignoreChar = '\u0000';
            this.endAtQuote = false;
        }

        boolean readNext() {
            char c = this.string.charAt(this.index);
            FormatSet formatSet = (FormatSet)this.this$0.coloringModes.get(Character.valueOf(c));
            AbstractParserState abstractParserState = null;
            if (formatSet != null && this.ignoreChar != c) {
                ColoringState coloringState = new ColoringState(this.this$0, this.dest, this.attrs.union(formatSet), this.string, this.index + 1);
                coloringState.ignore(c);
                if (this.endAtQuote) {
                    coloringState.setForceEndAtQuote();
                }
                abstractParserState = coloringState;
            } else if (c == '\\') {
                QuoteState quoteState = new QuoteState(this.this$0, this.dest, this.attrs, this.string, this.index + 1);
                abstractParserState = quoteState;
            }
            if (abstractParserState != null) {
                this.push();
                this.beginIndex = this.index = abstractParserState.parse();
            } else {
                ++this.index;
            }
            return true;
        }

        void ignore(char c) {
            this.ignoreChar = c;
        }

        @Override
        int parse() {
            while (this.index < this.string.length()) {
                if (this.readNext()) continue;
                return this.index;
            }
            this.push();
            return this.index;
        }
    }

    private abstract class AbstractParserState {
        final T attrs;
        int beginIndex;
        int index;
        final AttributedTextSink<T> dest;
        final String string;
        final /* synthetic */ StringFormatter this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        AbstractParserState(AttributedTextSink<T> attributedTextSink, T t, String string, int n2) {
            this.this$0 = (StringFormatter)n;
            this.attrs = t;
            this.beginIndex = n2;
            this.index = n2;
            this.dest = attributedTextSink;
            this.string = string;
        }

        void push() {
            int n = Math.min(this.index, this.string.length());
            if (n > this.beginIndex) {
                this.dest.append(this.string.substring(this.beginIndex, n), this.attrs);
                this.beginIndex = this.index;
            }
        }

        abstract int parse();
    }
}

