/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.sound;

import games.stendhal.client.MemoryCache;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sound.facade.AudibleArea;
import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.client.sound.manager.AudioResource;
import games.stendhal.client.sound.manager.DeviceEvaluator;
import games.stendhal.client.sound.manager.SoundManagerNG;
import games.stendhal.common.math.Numeric;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioFormat;
import org.apache.log4j.Logger;

public class ExtendedSoundManager
extends SoundManagerNG {
    private static Logger logger = Logger.getLogger(ExtendedSoundManager.class);
    private static final AudioFormat mAudioFormat;
    private static final DeviceEvaluator mDeviceEvaluator;
    private final MemoryCache<String, SoundManagerNG.Sound> mSounds = new MemoryCache();
    private final Map<String, Group> mGroups = new LinkedHashMap<String, Group>();
    private float mMasterVolume = 1.0f;

    ExtendedSoundManager() {
        super(!WtWindowManager.getInstance().getPropertyBoolean("sound.play", true), mDeviceEvaluator.createDeviceList(mAudioFormat), mAudioFormat);
        this.initVolumes();
    }

    private void initVolumes() {
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        int n = wtWindowManager.getPropertyInt("sound.volume.master", 100);
        this.changeVolume(Numeric.intToFloat(n, 100.0f));
        this.getGroup("gui").changeVolume(Numeric.intToFloat(wtWindowManager.getPropertyInt("sound.volume.gui", 100), 100.0f));
        this.getGroup("sfx").changeVolume(Numeric.intToFloat(wtWindowManager.getPropertyInt("sound.volume.sfx", 100), 100.0f));
        this.getGroup("creature").changeVolume(Numeric.intToFloat(wtWindowManager.getPropertyInt("sound.volume.creature", 95), 100.0f));
        this.getGroup("ambient").changeVolume(Numeric.intToFloat(wtWindowManager.getPropertyInt("sound.volume.ambient", 80), 100.0f));
        this.getGroup("music").changeVolume(Numeric.intToFloat(wtWindowManager.getPropertyInt("sound.volume.music", 60), 100.0f));
    }

    public Group getGroup(String string) {
        Group group = this.mGroups.get(string);
        if (group == null) {
            group = new Group();
            this.mGroups.put(string, group);
        }
        return group;
    }

    public Collection<String> getGroupNames() {
        return this.mGroups.keySet();
    }

    public float getVolume() {
        return this.mMasterVolume;
    }

    public void changeVolume(float f) {
        this.mMasterVolume = f;
        for (SoundManagerNG.Sound sound : this.getActiveSounds()) {
            Multiplicator multiplicator = sound.getAttachment(Multiplicator.class);
            if (multiplicator == null) continue;
            super.changeVolume(sound, this.mMasterVolume * multiplicator.group.mVolume * multiplicator.value);
        }
    }

    static {
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        mDeviceEvaluator = new DeviceEvaluator();
        String string = wtWindowManager.getProperty("sound.device", "auto");
        if (!string.equals("auto - recommended")) {
            logger.info((Object)("User selected sound device: " + string));
            mDeviceEvaluator.setRating(Pattern.compile(Pattern.quote(string)), null, 100);
        }
        mDeviceEvaluator.setRating(Pattern.compile(".*default.*", 2), null, 3);
        mDeviceEvaluator.setRating(Pattern.compile(".*pulseaudio.*", 2), null, 2);
        mDeviceEvaluator.setRating(Pattern.compile(".*plughw.0.0.*"), null, 1);
        mDeviceEvaluator.setRating(Pattern.compile(".*Java Sound Audio Engine.*"), null, -1);
        mAudioFormat = new AudioFormat(44100.0f, 16, 2, true, false);
    }

    public class Group
    implements SoundGroup {
        private final boolean mEnabled = true;
        private float mVolume = 1.0f;
        private final MemoryCache<String, SoundManagerNG.Sound> mGroupSounds = new MemoryCache();
        private boolean streaming = false;

        @Override
        public boolean loadSound(String string, String string2, SoundFileType soundFileType, boolean bl) {
            try {
                SoundManagerNG.Sound sound = (SoundManagerNG.Sound)ExtendedSoundManager.this.mSounds.get(string);
                if (sound == null && (sound = ExtendedSoundManager.this.openSound(new AudioResource(string2), soundFileType, 256, bl)) != null) {
                    ExtendedSoundManager.this.mSounds.put(string, sound);
                }
                if (sound != null) {
                    this.mGroupSounds.put(string, sound);
                }
                return sound != null;
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)runtimeException, (Throwable)runtimeException);
                return false;
            }
        }

        @Override
        public float getVolume() {
            return this.mVolume;
        }

        @Override
        public void changeVolume(float f) {
            this.mVolume = f;
            for (SoundManagerNG.Sound sound : ExtendedSoundManager.this.getActiveSounds()) {
                Multiplicator multiplicator = sound.getAttachment(Multiplicator.class);
                if (multiplicator == null || multiplicator.group != this) continue;
                ExtendedSoundManager.this.changeVolume(sound, ExtendedSoundManager.this.mMasterVolume * this.mVolume * multiplicator.value);
            }
        }

        @Override
        public void enableStreaming() {
            this.streaming = true;
        }

        @Override
        public SoundManagerNG.Sound play(String string, int n, AudibleArea audibleArea, Time time, boolean bl, boolean bl2) {
            return this.play(string, 1.0f, n, audibleArea, time, bl, bl2);
        }

        @Override
        public SoundManagerNG.Sound play(String string, float f, int n, AudibleArea audibleArea, Time time, boolean bl, boolean bl2) {
            if (string == null) {
                return null;
            }
            try {
                SoundManagerNG.Sound sound = this.mGroupSounds.get(string);
                if (sound == null) {
                    this.loadSound(string, string + ".ogg", SoundFileType.OGG, this.streaming);
                    sound = this.mGroupSounds.get(string);
                }
                if (sound != null) {
                    if (bl2) {
                        sound = sound.clone();
                    }
                    sound.setAttachment(new Multiplicator(f, this));
                    ExtendedSoundManager.this.play(sound, ExtendedSoundManager.this.mMasterVolume * this.mVolume * f, n, audibleArea, bl, time);
                }
                return sound;
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)runtimeException, (Throwable)runtimeException);
                return null;
            }
        }
    }

    private static class Multiplicator {
        float value;
        Group group;

        public Multiplicator(float f, Group group) {
            this.value = f;
            this.group = group;
        }
    }
}

