/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system;

public abstract class SignalProcessor {
    private SignalProcessor mNext = null;
    private SignalProcessor mPrev = null;

    public final synchronized void insert(SignalProcessor signalProcessor, boolean bl) {
        assert (signalProcessor != this);
        if (this.mNext != null) {
            this.mNext.mPrev = this.mPrev;
        }
        if (this.mPrev != null) {
            this.mPrev.mNext = this.mNext;
        }
        if (signalProcessor != null) {
            if (bl) {
                this.mNext = signalProcessor;
                this.mPrev = signalProcessor.mPrev;
                if (signalProcessor.mPrev != null) {
                    signalProcessor.mPrev.mNext = this;
                }
                signalProcessor.mPrev = this;
            } else {
                this.mNext = signalProcessor.mNext;
                this.mPrev = signalProcessor;
                if (signalProcessor.mNext != null) {
                    signalProcessor.mNext.mPrev = this;
                }
                signalProcessor.mNext = this;
            }
        } else {
            this.mNext = null;
            this.mPrev = null;
        }
    }

    public final synchronized void connectTo(SignalProcessor signalProcessor, boolean bl) {
        if (bl) {
            if (this.mNext == signalProcessor) {
                return;
            }
            if (this.mNext != null) {
                this.mNext.mPrev = null;
            }
            if (signalProcessor.mPrev != null) {
                signalProcessor.mPrev.mNext = null;
            }
            this.mNext = signalProcessor;
            signalProcessor.mPrev = this;
        } else {
            if (this.mPrev == signalProcessor) {
                return;
            }
            if (this.mPrev != null) {
                this.mPrev.mNext = null;
            }
            if (signalProcessor.mNext != null) {
                signalProcessor.mNext.mPrev = null;
            }
            this.mPrev = signalProcessor;
            signalProcessor.mNext = this;
        }
    }

    public final synchronized void split(boolean bl) {
        if (bl) {
            if (this.mPrev != null) {
                this.mPrev.mNext = null;
                this.mPrev = null;
            }
        } else if (this.mNext != null) {
            this.mNext.mPrev = null;
            this.mNext = null;
        }
    }

    public final synchronized void replace(SignalProcessor signalProcessor) {
        if (signalProcessor == this) {
            return;
        }
        if (signalProcessor != null) {
            signalProcessor.disconnect();
            if (this.mNext != null) {
                this.mNext.mPrev = signalProcessor;
            }
            if (this.mPrev != null) {
                this.mPrev.mNext = signalProcessor;
            }
            signalProcessor.mNext = this.mNext;
            signalProcessor.mPrev = this.mPrev;
        } else {
            this.disconnect();
        }
    }

    public final void disconnect() {
        if (this.mNext != null) {
            this.mNext.mPrev = null;
            this.mNext = null;
        }
        if (this.mPrev != null) {
            this.mPrev.mNext = null;
            this.mPrev = null;
        }
    }

    protected final synchronized void propagate(float[] fArray, int n, int n2, int n3) {
        if (this.mNext != null) {
            this.mNext.modify(fArray, n, n2, n3);
        }
    }

    public final synchronized void quit() {
        if (this.mNext != null) {
            this.mNext.finished();
        }
    }

    public synchronized boolean request() {
        if (this.mPrev != null) {
            return this.mPrev.request();
        }
        return this.generate();
    }

    protected void modify(float[] fArray, int n, int n2, int n3) {
        this.propagate(fArray, n, n2, n3);
    }

    protected boolean generate() {
        return false;
    }

    protected void finished() {
        this.quit();
    }

    public static void createChain(SignalProcessor ... signalProcessorArray) {
        int n = signalProcessorArray.length;
        if (n >= 2) {
            for (int i = 1; i < n - 1; ++i) {
                signalProcessorArray[i].insert(signalProcessorArray[i - 1], false);
            }
            signalProcessorArray[0].connectTo(signalProcessorArray[1], true);
            signalProcessorArray[n - 1].connectTo(signalProcessorArray[n - 2], false);
        }
    }
}

