/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system;

import games.stendhal.client.sound.Dsp;
import games.stendhal.client.sound.Field;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.common.math.Numeric;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.apache.log4j.Logger;

public class SoundSystemNG
extends Thread {
    private static final int STATE_EXITING = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_PAUSING = 2;
    private static final int STATE_SUSPENDED = 3;
    private static final Time ZERO_DURATION = new Time();
    private static final Time SLEEP_DURATION = new Time(100L, Time.Unit.MILLI);
    private static final int PRECISION = 1000000;
    private static final Logger logger = Logger.getLogger(SoundSystemNG.class);
    private final LinkedList<Output> mMixerOutputs = new LinkedList();
    private volatile SystemOutput mSystemOutput = null;
    private volatile AudioFormat mAudioFormat = null;
    private final AtomicReference<Time> mBufferDuration = new AtomicReference<Object>(null);
    private final AtomicBoolean mUseDynamicLoadScaling = new AtomicBoolean(false);
    private final AtomicReference<Time> mStateChangeDelay = new AtomicReference<Time>(ZERO_DURATION);
    private final AtomicInteger mTargetSystemState = new AtomicInteger(0);
    private final AtomicInteger mCurrentSystemState = new AtomicInteger(0);
    private float[] mMixBuffer = null;

    public SoundSystemNG(AudioFormat audioFormat, Time time) {
        this.init(null, audioFormat, time);
    }

    public SoundSystemNG(SourceDataLine sourceDataLine, Time time) {
        if (sourceDataLine == null) {
            throw new IllegalArgumentException("outputLine argument must not be null");
        }
        if (time == null) {
            throw new IllegalArgumentException("bufferDuration argument must not be null");
        }
        this.init(sourceDataLine, sourceDataLine.getFormat(), time);
    }

    public void suspend(Time time, boolean bl) {
        if (bl) {
            this.changeSystemState(3, time);
        } else {
            this.changeSystemState(2, time);
        }
    }

    public void proceed(Time time) {
        this.changeSystemState(1, time);
    }

    public void proceed(Time time, SourceDataLine sourceDataLine) {
        if (sourceDataLine != null && !sourceDataLine.getFormat().matches(this.mAudioFormat)) {
            throw new IllegalArgumentException("outputLine has the wrong audio format");
        }
        this.init(sourceDataLine, this.mAudioFormat, this.mBufferDuration.get());
        this.changeSystemState(1, time);
    }

    public boolean isRunning() {
        return this.mCurrentSystemState.get() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output openOutput(int n, SignalProcessor ... signalProcessorArray) {
        Output output = new Output(this.mAudioFormat, n);
        SignalProcessor.createChain(Field.append(signalProcessorArray, signalProcessorArray.length, output));
        LinkedList<Output> linkedList = this.mMixerOutputs;
        synchronized (linkedList) {
            this.mMixerOutputs.add(output);
        }
        logger.debug((Object)"opening a mixer output (using manual mixing)");
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOutput(Output output) {
        if (output != null) {
            output.disconnect();
            LinkedList<Output> linkedList = this.mMixerOutputs;
            synchronized (linkedList) {
                logger.debug((Object)"closing a mixer output");
                this.mMixerOutputs.remove(output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllOutputs() {
        logger.debug((Object)"closing all outputs excluding the output for manual mixing");
        LinkedList<Output> linkedList = this.mMixerOutputs;
        synchronized (linkedList) {
            this.mMixerOutputs.clear();
        }
    }

    public void exit(Time time) {
        logger.info((Object)("stopping sound system after " + (time != null ? time.getInMilliSeconds() : 0.0) + "ms"));
        this.changeSystemState(0, time);
    }

    @Override
    public void run() {
        double d = 0.0;
        double d2 = 0.995;
        class StateChanger {
            long mSystemTime = 0L;
            boolean mChangeState = false;

            StateChanger() {
            }

            void processStateChange() {
                if (!this.mChangeState) {
                    if (SoundSystemNG.this.mCurrentSystemState.get() != SoundSystemNG.this.mTargetSystemState.get()) {
                        logger.debug((Object)"change state");
                        if (((Time)SoundSystemNG.this.mStateChangeDelay.get()).getInNanoSeconds() <= 0L) {
                            SoundSystemNG.this.mCurrentSystemState.set(SoundSystemNG.this.mTargetSystemState.get());
                            return;
                        }
                        this.mSystemTime = System.nanoTime();
                        this.mChangeState = true;
                    }
                } else if (System.nanoTime() - this.mSystemTime >= ((Time)SoundSystemNG.this.mStateChangeDelay.get()).getInNanoSeconds()) {
                    SoundSystemNG.this.mCurrentSystemState.set(SoundSystemNG.this.mTargetSystemState.get());
                    this.mChangeState = false;
                }
            }
        }
        StateChanger stateChanger = new StateChanger();
        this.mCurrentSystemState.set(1);
        this.mTargetSystemState.set(1);
        this.mStateChangeDelay.set(ZERO_DURATION);
        block5: while (this.mCurrentSystemState.get() != 0) {
            stateChanger.processStateChange();
            switch (this.mCurrentSystemState.get()) {
                case 1: {
                    if (this.mSystemOutput == null) {
                        this.changeSystemState(3, null);
                        logger.warn((Object)"no output line was opened. sound system will be suspended");
                        break;
                    }
                    if (!this.mSystemOutput.isReady() && !this.mSystemOutput.start()) {
                        this.changeSystemState(3, null);
                        logger.warn((Object)"suspend sound system due to unavailability of an output line");
                        break;
                    }
                    long l = System.nanoTime();
                    long l2 = this.mBufferDuration.get().getInNanoSeconds();
                    this.processOutputs();
                    if (!this.mUseDynamicLoadScaling.get()) continue block5;
                    l = System.nanoTime() - l;
                    if ((d = (d + (double)l) / 2.0) > (double)l2) {
                        d = l2;
                    }
                    long l3 = (long)(((double)l2 - d) * d2);
                    this.threadSleep(l3);
                    break;
                }
                case 2: {
                    this.mSystemOutput.pause();
                    this.threadSleep(SLEEP_DURATION.getInNanoSeconds());
                    break;
                }
                case 3: {
                    if (this.mSystemOutput != null) {
                        this.mSystemOutput.close();
                    }
                    this.threadSleep(SLEEP_DURATION.getInNanoSeconds());
                }
            }
        }
        this.closeAllOutputs();
        if (this.mSystemOutput != null) {
            this.mSystemOutput.close();
        }
    }

    private void changeSystemState(int n, Time time) {
        time = time == null ? ZERO_DURATION : time.clone();
        this.mStateChangeDelay.set(time);
        this.mTargetSystemState.set(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutputs() {
        LinkedList linkedList;
        SystemOutput systemOutput = this.mSystemOutput;
        LinkedList<Output> linkedList2 = this.mMixerOutputs;
        synchronized (linkedList2) {
            linkedList = (LinkedList)this.mMixerOutputs.clone();
        }
        int n = systemOutput.getSampleRate();
        int n2 = systemOutput.getNumBytesPerSample();
        int n3 = systemOutput.getNumChannels();
        int n4 = (int)(this.mBufferDuration.get().getInSamples(n) * (double)n3 * (double)n2);
        systemOutput.setNumBytesToWrite(n4);
        n4 = systemOutput.getNumBytesToWrite();
        int n5 = n4 / n2;
        this.mMixBuffer = Field.expand(this.mMixBuffer, n5, false);
        Arrays.fill(this.mMixBuffer, 0, n5, 0.0f);
        for (Output output : linkedList) {
            output.mix(this.mMixBuffer, n5);
        }
        systemOutput.setBuffer(this.mMixBuffer, n5);
        systemOutput.convert();
        boolean bl = false;
        while (systemOutput.write(Integer.MAX_VALUE)) {
            if (systemOutput.available() < systemOutput.getFrameSize()) {
                if (bl) {
                    return;
                }
                this.threadSleep(SLEEP_DURATION.getInNanoSeconds());
                bl = true;
                continue;
            }
            bl = false;
        }
    }

    private void init(SourceDataLine sourceDataLine, AudioFormat audioFormat, Time time) {
        this.mBufferDuration.set(time);
        this.mAudioFormat = audioFormat;
        if (sourceDataLine != null) {
            logger.info((Object)("opening sound system with line \"" + sourceDataLine + "\" and audio format \"" + audioFormat + "\""));
            this.mSystemOutput = new SystemOutput(sourceDataLine);
        } else {
            this.mSystemOutput = null;
        }
    }

    private void threadSleep(long l) {
        try {
            long l2 = l / Time.Unit.MILLI.getNanos();
            SoundSystemNG.sleep(l2, (int)(l %= Time.Unit.MILLI.getNanos()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class Output
    extends SignalProcessor {
        AudioFormat mAudioFormat;
        float[] mAudioBuffer = null;
        float[] mMixingBuffer = null;
        int mNumSamples = 0;
        int mNumSamplesMixed = 0;
        final AtomicInteger mLevel = new AtomicInteger(0);
        final AtomicInteger mIntensity = new AtomicInteger(1000000);

        Output(AudioFormat audioFormat, int n) {
            assert (audioFormat != null);
            this.mAudioFormat = audioFormat;
            this.mLevel.set(n);
        }

        public void setIntensity(float f) {
            this.mIntensity.set(Numeric.floatToInt(f, 1000000.0f));
        }

        public float getIntensity() {
            return Numeric.intToFloat(this.mIntensity.get(), 1000000.0f);
        }

        boolean receivedData() {
            return this.mNumSamples > 0;
        }

        int getNumChannels() {
            return this.mAudioFormat.getChannels();
        }

        int getSampleRate() {
            return (int)this.mAudioFormat.getSampleRate();
        }

        int getLayer() {
            return this.mLevel.get();
        }

        float[] getMixingBuffer() {
            return this.mMixingBuffer;
        }

        void reset() {
            this.mNumSamples = 0;
            this.mNumSamplesMixed = 0;
        }

        void clearMixingBuffer(int n) {
            this.mMixingBuffer = Field.expand(this.mMixingBuffer, n, false);
            Arrays.fill(this.mMixingBuffer, 0.0f);
        }

        void setBuffer(float[] fArray, int n) {
            assert (fArray == null || n <= fArray.length);
            assert (n % this.getNumChannels() == 0);
            this.mAudioBuffer = fArray;
            this.mNumSamples = n;
        }

        boolean mix(float[] fArray, int n) {
            int n2;
            int n3 = 0;
            for (int i = n; i > 0; i -= n2) {
                if (!this.receivedData()) {
                    this.request();
                }
                if (!this.receivedData()) {
                    return false;
                }
                n2 = this.mNumSamples - this.mNumSamplesMixed;
                n2 = Math.min(n2, i);
                Dsp.mixAudioData(fArray, n3, this.mAudioBuffer, this.mNumSamplesMixed, n2, Numeric.intToFloat(this.mIntensity.get(), 1000000.0f));
                n3 += n2;
                this.mNumSamplesMixed += n2;
                if (this.mNumSamples != this.mNumSamplesMixed) continue;
                this.reset();
            }
            return true;
        }

        @Override
        protected void modify(float[] fArray, int n, int n2, int n3) {
            if (fArray != null && n > 0 && n2 > 0 && n3 > 0) {
                assert (n * n2 <= fArray.length);
                fArray = Dsp.convertChannels(fArray, n, n2, this.getNumChannels());
                this.setBuffer(fArray, n * this.getNumChannels());
                fArray = Dsp.convertSampleRate(fArray, n * n2, n2, n3, this.getSampleRate());
                float f = (float)n / (float)n3;
                this.setBuffer(fArray, (int)(f * (float)this.getSampleRate() * (float)n2));
            } else {
                this.setBuffer(null, 0);
                assert (false) : "could not convert sample rate";
            }
        }
    }

    private static class SystemOutput {
        final SourceDataLine mLine;
        final AudioFormat mFormat;
        float[] mAudioBuffer = null;
        int mNumSamples = 0;
        byte[] mPCMBuffer = null;
        int mPCMBufferSize = 0;
        int mNumBytesWritten = 0;
        int mNumBytesToWrite = 0;

        SystemOutput(SourceDataLine sourceDataLine) {
            assert (sourceDataLine != null);
            this.mLine = sourceDataLine;
            this.mFormat = sourceDataLine.getFormat();
        }

        boolean isReady() {
            return this.mLine.isOpen() && this.mLine.isRunning();
        }

        int getNumChannels() {
            return this.mFormat.getChannels();
        }

        int getSampleRate() {
            return (int)this.mFormat.getSampleRate();
        }

        int getNumBytesPerSample() {
            return this.mFormat.getSampleSizeInBits() / 8;
        }

        int available() {
            return this.mLine.available();
        }

        int getNumBytesToWrite() {
            return this.mNumBytesToWrite;
        }

        int getFrameSize() {
            return this.getNumBytesPerSample() * this.getNumChannels();
        }

        void close() {
            if (this.mLine.isOpen()) {
                this.mLine.close();
            }
        }

        boolean start() {
            if (!this.mLine.isOpen()) {
                try {
                    this.mLine.open();
                }
                catch (LineUnavailableException lineUnavailableException) {
                    return false;
                }
                catch (SecurityException securityException) {
                    return false;
                }
            }
            if (!this.mLine.isRunning()) {
                this.mLine.start();
            }
            return true;
        }

        void pause() {
            if (this.mLine != null && this.mLine.isOpen() && this.mLine.isRunning()) {
                this.mLine.stop();
                this.mLine.flush();
            }
        }

        void reset() {
            this.mNumBytesWritten = 0;
            this.mNumSamples = 0;
            this.mPCMBufferSize = 0;
        }

        void setBuffer(float[] fArray, int n) {
            assert (n <= fArray.length);
            assert (n % this.getNumChannels() == 0);
            this.mAudioBuffer = fArray;
            this.mNumSamples = n;
        }

        void setNumBytesToWrite(int n) {
            int n2 = this.getNumBytesPerSample() * this.getNumChannels();
            this.mNumBytesToWrite = Math.min(n, this.mLine.getBufferSize());
            this.mNumBytesToWrite /= n2;
            this.mNumBytesToWrite *= n2;
        }

        void convert() {
            assert (this.mLine.getFormat().getSampleSizeInBits() % 8 == 0);
            int n = this.getNumBytesPerSample();
            int n2 = n * this.mNumSamples;
            this.mPCMBuffer = Field.expand(this.mPCMBuffer, n2, false);
            this.mPCMBuffer = Dsp.convertUniformPCM(this.mPCMBuffer, this.mAudioBuffer, this.mNumSamples, n);
            this.mPCMBufferSize = n2;
        }

        boolean write(int n) {
            int n2 = this.getNumBytesPerSample() * this.getNumChannels();
            int n3 = this.mPCMBufferSize - this.mNumBytesWritten;
            int n4 = this.mLine.available();
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            n = Math.min(n, n3);
            n = Math.min(n, this.mNumBytesToWrite);
            n = Math.min(n, n4);
            n /= n2;
            n *= n2;
            n = this.mLine.write(this.mPCMBuffer, this.mNumBytesWritten, n);
            if (n4 > 0 && n == 0) {
                return false;
            }
            this.mNumBytesWritten += n;
            this.mNumBytesToWrite -= n;
            if ((n3 -= n) < n2) {
                this.reset();
            }
            return this.mNumBytesToWrite >= n2;
        }
    }
}

