/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.sprite.Tileset;
import java.awt.Color;
import java.awt.Composite;

public class SpriteTileset
implements Tileset {
    private Sprite[] tiles;

    public SpriteTileset(SpriteStore spriteStore, String string, Color color, Composite composite) {
        this(spriteStore, spriteStore.getModifiedSprite(string, color, composite), 32);
    }

    public SpriteTileset(SpriteStore spriteStore, Sprite sprite, int n) {
        this.tiles = sprite == null ? new Sprite[0] : this.extractTiles(spriteStore, sprite, n);
    }

    private Sprite[] extractTiles(SpriteStore spriteStore, Sprite sprite, int n) {
        int n2 = sprite.getHeight() / n;
        int n3 = sprite.getWidth() / n;
        Sprite[] spriteArray = new Sprite[n2 * n3];
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = 0;
            for (int j = 0; j < n3; ++j) {
                spriteArray[n4++] = spriteStore.getTile(sprite, n6, n5, n, n);
                n6 += n;
            }
            n5 += n;
        }
        return spriteArray;
    }

    @Override
    public int getSize() {
        return this.tiles.length;
    }

    @Override
    public Sprite getSprite(int n) {
        if (n < this.tiles.length) {
            return this.tiles[n];
        }
        return null;
    }
}

