/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.sprite.ImageSprite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.font.LineMetrics;
import java.awt.image.BufferedImage;

public class TextSprite
extends ImageSprite {
    private static final Graphics graphics = new BufferedImage(1, 1, 1).getGraphics();

    private TextSprite(Image image) {
        super(image);
    }

    public static TextSprite createTextSprite(String string, Color color) {
        GraphicsConfiguration graphicsConfiguration = TextSprite.getGC();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(string, graphics);
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(fontMetrics.stringWidth(string) + 2, Math.round(lineMetrics.getHeight()) + 2, TransparencyMode.TRANSPARENCY);
        TextSprite.drawOutlineString(bufferedImage, color, string, 1, Math.round(lineMetrics.getAscent()));
        return new TextSprite(bufferedImage);
    }

    private static void drawOutlineString(Image image, Color color, String string, int n, int n2) {
        int n3 = (color.getRed() * 299 + color.getGreen() * 587 + color.getBlue() * 114) / 1000;
        Color color2 = n3 >= 64 ? Color.black : Color.lightGray;
        TextSprite.drawOutlineString(image, color, color2, string, n, n2);
    }

    private static void drawOutlineString(Image image, Color color, Color color2, String string, int n, int n2) {
        Graphics graphics = image.getGraphics();
        graphics.setColor(color2);
        graphics.drawString(string, n - 1, n2 - 1);
        graphics.drawString(string, n + 1, n2 + 1);
        graphics.drawString(string, n - 1, n2 + 1);
        graphics.drawString(string, n, n2 - 1);
        graphics.drawString(string, n + 1, n2);
        graphics.drawString(string, n - 1, n2);
        graphics.drawString(string, n, n2 + 1);
        graphics.drawString(string, n + 1, n2 - 1);
        graphics.setColor(color);
        graphics.drawString(string, n, n2);
    }
}

