/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common;

import games.stendhal.common.Rand;
import java.awt.geom.Rectangle2D;

public enum Direction {
    STOP(0, 0, 0){

        @Override
        public Direction nextDirection() {
            return LEFT;
        }

        @Override
        public Direction oppositeDirection() {
            return STOP;
        }
    }
    ,
    UP(1, 0, -1){

        @Override
        public Direction nextDirection() {
            return RIGHT;
        }

        @Override
        public Direction oppositeDirection() {
            return DOWN;
        }
    }
    ,
    RIGHT(2, 1, 0){

        @Override
        public Direction nextDirection() {
            return DOWN;
        }

        @Override
        public Direction oppositeDirection() {
            return LEFT;
        }
    }
    ,
    DOWN(3, 0, 1){

        @Override
        public Direction nextDirection() {
            return LEFT;
        }

        @Override
        public Direction oppositeDirection() {
            return UP;
        }
    }
    ,
    LEFT(4, -1, 0){

        @Override
        public Direction nextDirection() {
            return UP;
        }

        @Override
        public Direction oppositeDirection() {
            return RIGHT;
        }
    };

    private final int val;
    private final int dx;
    private final int dy;

    public static Direction build(int n) {
        switch (n) {
            case 1: {
                return UP;
            }
            case 2: {
                return RIGHT;
            }
            case 3: {
                return DOWN;
            }
            case 4: {
                return LEFT;
            }
        }
        return STOP;
    }

    public int getdx() {
        return this.dx;
    }

    public int getdy() {
        return this.dy;
    }

    public static Direction rand() {
        return Direction.values()[Rand.rand(4) + 1];
    }

    private Direction(int n2, int n3, int n4) {
        this.val = n2;
        this.dx = n3;
        this.dy = n4;
    }

    public int get() {
        return this.val;
    }

    public static Direction getAreaDirectionTowardsArea(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D2.getCenterX() - rectangle2D.getCenterX();
        double d2 = rectangle2D2.getCenterY() - rectangle2D.getCenterY();
        if (Math.abs(d) > Math.abs(d2)) {
            if (d > 0.0) {
                return RIGHT;
            }
            return LEFT;
        }
        if (d2 > 0.0) {
            return DOWN;
        }
        return UP;
    }

    public abstract Direction oppositeDirection();

    public abstract Direction nextDirection();
}

