/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.color;

public class HSL {
    public static void rgb2hsl(int[] nArray, float[] fArray) {
        float f;
        float f2;
        int n;
        float f3;
        float f4;
        float f5 = (float)nArray[1] / 255.0f;
        float f6 = (float)nArray[2] / 255.0f;
        float f7 = (float)nArray[3] / 255.0f;
        if (f5 > f6) {
            f4 = f5;
            f3 = f6;
            n = 1;
        } else {
            f4 = f6;
            f3 = f5;
            n = 2;
        }
        if (f7 > f4) {
            f4 = f7;
            n = 3;
        } else if (f7 < f3) {
            f3 = f7;
        }
        float f8 = (f4 + f3) / 2.0f;
        float f9 = f4 - f3;
        if (f9 < 1.0E-7f) {
            f2 = 0.0f;
            f = 0.0f;
        } else {
            f2 = f8 < 0.5f ? f9 / (f4 + f3) : f9 / (2.0f - f4 - f3);
            f = n == 1 ? (f6 - f7) / f9 : (n == 2 ? 2.0f + (f7 - f5) / f9 : 4.0f + (f5 - f6) / f9);
            f /= 6.0f;
        }
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f8;
    }

    public static void hsl2rgb(float[] fArray, int[] nArray) {
        int n;
        int n2;
        int n3;
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        if (f2 < 1.0E-7f) {
            n2 = n3 = (int)(255.0f * f3);
            n = n3;
        } else {
            float f4 = f3 < 0.5f ? f3 * (1.0f + f2) : f3 + f2 - f3 * f2;
            float f5 = 2.0f * f3 - f4;
            float f6 = HSL.hue2rgb(HSL.limitHue(f + 0.33333334f), f5, f4);
            float f7 = HSL.hue2rgb(HSL.limitHue(f), f5, f4);
            float f8 = HSL.hue2rgb(HSL.limitHue(f - 0.33333334f), f5, f4);
            n = (int)(255.0f * f6) & 0xFF;
            n2 = (int)(255.0f * f7) & 0xFF;
            n3 = (int)(255.0f * f8) & 0xFF;
        }
        nArray[1] = n;
        nArray[2] = n2;
        nArray[3] = n3;
    }

    private static float limitHue(float f) {
        float f2 = f;
        if (f2 < 0.0f) {
            f2 += 1.0f;
        } else if (f2 > 1.0f) {
            f2 -= 1.0f;
        }
        return f2;
    }

    private static float hue2rgb(float f, float f2, float f3) {
        float f4 = f;
        f4 = 6.0f * f < 1.0f ? f2 + (f3 - f2) * 6.0f * f : (2.0f * f < 1.0f ? f3 : (3.0f * f < 2.0f ? f2 + (f3 - f2) * (0.6666667f - f) * 6.0f : f2));
        return f4;
    }
}

