/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.math;

import java.util.Arrays;

public final class Algebra {
    public static final float EPSILON = 1.0E-7f;

    public static float[] vecf(float ... fArray) {
        assert (fArray.length > 0);
        return fArray;
    }

    public static float[] homogenousf(float ... fArray) {
        assert (fArray.length > 0);
        int n = fArray.length - 1;
        float f = fArray[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            fArray[n3] = fArray[n3] * f;
        }
        return fArray;
    }

    public static boolean isEqual_Scalf(float f, float f2) {
        return Math.abs(f - f2) <= 1.0E-7f;
    }

    public static boolean isEqual_Vecf(float[] fArray, float[] fArray2) {
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray.length; ++i) {
            if (!(Math.abs(fArray[i] - fArray2[i]) > 1.0E-7f)) continue;
            return false;
        }
        return true;
    }

    public static void mov_Vecf(float[] fArray, float[] fArray2) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = fArray2[i];
        }
    }

    public static void mov_Vecf(float[] fArray, float f) {
        assert (fArray != null) : "method argument 1 is null";
        Arrays.fill(fArray, f);
    }

    public static void add_Vecf(float[] fArray, float[] fArray2, float[] fArray3) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray3 != null) : "method argument 3 is null";
        assert (fArray.length == fArray2.length && fArray2.length == fArray3.length);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = fArray2[i] + fArray3[i];
        }
    }

    public static void add_Vecf(float[] fArray, float[] fArray2, float f) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = fArray2[i] + f;
        }
    }

    public static void sub_Vecf(float[] fArray, float[] fArray2, float[] fArray3) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray3 != null) : "method argument 3 is null";
        assert (fArray.length == fArray2.length && fArray2.length == fArray3.length);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = fArray2[i] - fArray3[i];
        }
    }

    public static void sub_Vecf(float[] fArray, float[] fArray2, float f) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = fArray2[i] - f;
        }
    }

    public static void mul_Vecf(float[] fArray, float[] fArray2, float[] fArray3) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray3 != null) : "method argument 3 is null";
        assert (fArray.length == fArray2.length && fArray2.length == fArray3.length);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = fArray2[i] * fArray3[i];
        }
    }

    public static void mul_Vecf(float[] fArray, float[] fArray2, float f) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = fArray2[i] * f;
        }
    }

    public static void div_Vecf(float[] fArray, float[] fArray2, float[] fArray3) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray3 != null) : "method argument 3 is null";
        assert (fArray.length == fArray2.length && fArray2.length == fArray3.length);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = fArray2[i] / fArray3[i];
        }
    }

    public static void div_Vecf(float[] fArray, float[] fArray2, float f) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray.length == fArray2.length);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = fArray2[i] / f;
        }
    }

    public static float dot_Vecf(float[] fArray, float[] fArray2) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray.length == fArray2.length);
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i] * fArray2[i];
        }
        return f;
    }

    public static void cross_Vec3f(float[] fArray, float[] fArray2, float[] fArray3) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray3 != null) : "method argument 3 is null";
        assert (fArray.length == 3 && fArray2.length == 3 && fArray3.length == 3);
        float f = fArray2[1] * fArray3[2] - fArray3[1] * fArray2[2];
        float f2 = -fArray2[0] * fArray3[2] + fArray3[0] * fArray2[2];
        float f3 = fArray2[0] * fArray3[1] - fArray3[0] * fArray2[1];
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
    }

    public static void cross_Vec2f(float[] fArray, float[] fArray2) {
        float f;
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray.length == 2 && fArray2.length == 2);
        float f2 = fArray2[0];
        fArray[0] = f = fArray2[1];
        fArray[1] = -f2;
    }

    public static float lengthSqrt_Vecf(float[] fArray) {
        return Algebra.dot_Vecf(fArray, fArray);
    }

    public static float length_Vecf(float[] fArray) {
        return (float)Math.sqrt(Algebra.dot_Vecf(fArray, fArray));
    }

    public static void normalize_Vecf(float[] fArray, float[] fArray2) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray.length == fArray2.length);
        float f = 1.0f / Algebra.length_Vecf(fArray2);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray[i] = fArray2[i] * f;
        }
    }

    public static float distanceSqrt_Vecf(float[] fArray, float[] fArray2) {
        assert (fArray != null) : "method argument 1 is null";
        assert (fArray2 != null) : "method argument 2 is null";
        assert (fArray.length == fArray2.length);
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i] - fArray2[i];
            f += f2 * f2;
        }
        return f;
    }

    public static float distance_Vecf(float[] fArray, float[] fArray2) {
        return (float)Math.sqrt(Algebra.distanceSqrt_Vecf(fArray, fArray2));
    }

    public static float[] mat(boolean bl, float[] ... fArray) {
        assert (fArray.length != 0);
        assert (fArray[0] != null);
        assert (fArray[0].length != 0);
        int n = fArray[0].length;
        int n2 = fArray.length;
        float[] fArray2 = new float[n2 * n];
        int n3 = 0;
        if (bl) {
            for (float[] fArray3 : fArray) {
                assert (fArray3.length == n) : "all vectors must have equal length";
                System.arraycopy(fArray3, 0, fArray2, n3, n);
                n3 += n;
            }
        } else {
            for (float[] fArray4 : fArray) {
                assert (fArray4.length == n) : "all vectors must have equal length";
                int n4 = n3;
                float[] fArray5 = fArray4;
                int n5 = fArray5.length;
                for (int i = 0; i < n5; ++i) {
                    float f;
                    fArray2[n4] = f = fArray5[i];
                    n4 += n2;
                }
                ++n3;
            }
        }
        return fArray2;
    }

    public static float[] mul_mat(float[] fArray, int n, int n2, float[] fArray2, int n3, int n4) {
        assert (n2 == n3);
        assert (n * n2 != 0);
        assert (n3 * n4 != 0);
        int n5 = n * n4;
        float[] fArray3 = new float[n5];
        int n6 = 0;
        int n7 = 0;
        Arrays.fill(fArray3, 0.0f);
        while (n6 < n5) {
            for (int i = 0; i < n4; ++i) {
                int n8 = i;
                for (int j = 0; j < n2; ++j) {
                    int n9 = n7 + i;
                    fArray3[n9] = fArray3[n9] + fArray[n6 + j] * fArray2[n8];
                    n8 += n4;
                }
            }
            n6 += n2;
            n7 += n4;
        }
        return fArray3;
    }
}

