/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public final class ExpressionType
implements Serializable {
    private static final long serialVersionUID = -8694964043717271498L;
    public static final String VERB = "VER";
    public static final String GERUND = "GER";
    public static final String CONDITIONAL = "CON";
    public static final String NEGATED = "NEG";
    public static final String PRONOUN = "PRO";
    public static final String OBJECT = "OBJ";
    public static final String FLUID = "FLU";
    public static final String FOOD = "FOO";
    public static final String OBSESSIONAL = "OBS";
    public static final String SUBJECT = "SUB";
    public static final String ANIMAL = "ANI";
    public static final String NAME = "NAM";
    public static final String ADJECTIVE = "ADJ";
    public static final String COLOR = "COL";
    public static final String NUMERAL = "NUM";
    public static final String PREPOSITION = "PRE";
    public static final String QUESTION = "QUE";
    public static final String IGNORE = "IGN";
    public static final String SUFFIX = "-";
    public static final String PLURAL = "PLU";
    public static final String DYNAMIC = "DYN";
    public static final String UNKNOWN = "";
    public static final String SUFFIX_GERUND = "-GER";
    public static final String SUFFIX_COLOR = "-COL";
    public static final String SUFFIX_CONDITIONAL = "-CON";
    public static final String SUFFIX_NEGATED = "-NEG";
    public static final String SUFFIX_PRONOUN = "-PRO";
    public static final String SUFFIX_FOOD = "-FOO";
    public static final String SUFFIX_OBSESSIONAL = "-OBS";
    public static final String SUFFIX_FLUID = "-FLU";
    public static final String SUFFIX_ANIMAL = "-ANI";
    public static final String SUFFIX_NAME = "-NAM";
    public static final String SUBJECT_NAME = "SUB-NAM";
    public static final String SUFFIX_PLURAL = "-PLU";
    public static final String SUFFIX_QUESTION = "-QUE";
    public static final String VERB_GERUND = "VER-GER";
    public static final String SUFFIX_DYNAMIC = "-DYN";
    public static final List<String> TYPESTRINGS = Arrays.asList("VER", "OBJ", "SUB", "ADJ", "NUM", "PRE", "QUE", "IGN", "-GER", "-COL", "-CON", "-NEG", "-PRO", "-FOO", "-OBS", "-FLU", "-ANI", "-NAM", "-PLU");
    private final String typeString;

    public ExpressionType(String string) {
        this.typeString = string;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public String getMainType() {
        if (this.typeString.length() >= 3) {
            return this.typeString.substring(0, 3);
        }
        return this.typeString;
    }

    public boolean isEmpty() {
        return this.typeString.length() == 0;
    }

    public boolean isVerb() {
        return this.typeString.startsWith(VERB);
    }

    public boolean isGerund() {
        return this.typeString.startsWith(VERB_GERUND);
    }

    public boolean isObject() {
        return this.typeString.startsWith(OBJECT);
    }

    public boolean isSubject() {
        return this.typeString.startsWith(SUBJECT);
    }

    public boolean isNumeral() {
        return this.typeString.startsWith(NUMERAL);
    }

    public boolean isAdjective() {
        return this.typeString.startsWith(ADJECTIVE);
    }

    public boolean isPreposition() {
        return this.typeString.startsWith(PREPOSITION);
    }

    public boolean isIgnore() {
        return this.typeString.startsWith(IGNORE);
    }

    public boolean isPlural() {
        return this.typeString.contains(SUFFIX_PLURAL);
    }

    public boolean isName() {
        return this.typeString.contains(SUFFIX_NAME);
    }

    public boolean isAnimal() {
        return this.typeString.contains(SUFFIX_ANIMAL);
    }

    public boolean isFood() {
        return this.typeString.contains(SUFFIX_FOOD);
    }

    public boolean isFluid() {
        return this.typeString.contains(SUFFIX_FLUID);
    }

    public boolean isQuestion() {
        return this.typeString.startsWith(QUESTION);
    }

    public boolean hasQuestion() {
        return this.typeString.contains(QUESTION);
    }

    public boolean isObsessional() {
        return this.typeString.contains(SUFFIX_OBSESSIONAL);
    }

    public boolean hasColor() {
        return this.typeString.contains(COLOR);
    }

    public boolean isPronoun() {
        return this.typeString.contains(SUFFIX_PRONOUN);
    }

    public boolean isConditional() {
        return this.typeString.contains(SUFFIX_CONDITIONAL);
    }

    public boolean isNegated() {
        return this.typeString.contains(SUFFIX_NEGATED);
    }

    public boolean isDynamic() {
        return this.typeString.contains(SUFFIX_DYNAMIC);
    }

    public static boolean isTypeString(String string) {
        char c;
        if (string.length() > 0 && Character.isUpperCase(c = string.charAt(0))) {
            for (String string2 : TYPESTRINGS) {
                if (!string.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public ExpressionType merge(ExpressionType expressionType) {
        String string = this.typeString;
        boolean bl = false;
        if (expressionType.hasColor() && !this.hasColor()) {
            string = string + SUFFIX_COLOR;
            bl = true;
        }
        if (expressionType.hasQuestion() && !this.hasQuestion()) {
            string = string + SUFFIX_QUESTION;
            bl = true;
        }
        if (expressionType.isConditional() && !this.isConditional()) {
            string = string + SUFFIX_CONDITIONAL;
            bl = true;
        }
        if (expressionType.isPronoun() && !this.isPronoun()) {
            string = string + SUFFIX_PRONOUN;
            bl = true;
        }
        if (expressionType.isNegated() != this.isNegated()) {
            string = string + SUFFIX_NEGATED;
            bl = true;
        }
        if (expressionType.isDynamic() && !this.isDynamic()) {
            string = string + SUFFIX_DYNAMIC;
            bl = true;
        }
        if (bl) {
            return new ExpressionType(string);
        }
        return this;
    }

    public ExpressionType negate() {
        if (this.isNegated()) {
            return new ExpressionType(this.typeString.replace(SUFFIX_NEGATED, UNKNOWN));
        }
        return new ExpressionType(this.typeString + SUFFIX_NEGATED);
    }

    public String toString() {
        return this.typeString;
    }
}

