/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

public final class PunctuationParser {
    private String text;
    private String preceding = "";
    private String trailing = "";

    public PunctuationParser(String string) {
        if (string != null) {
            this.parseString(string);
        }
    }

    private void parseString(String string) {
        this.text = string;
        this.extractPreceedingAndTrimText();
        this.extractTrailingAndTrimText();
    }

    private void extractTrailingAndTrimText() {
        int n;
        for (n = this.text.length() - 1; n >= 0 && this.isPunctuation(this.text.charAt(n)); --n) {
        }
        this.trailing = this.text.substring(n + 1);
        this.text = this.text.substring(0, n + 1);
    }

    private void extractPreceedingAndTrimText() {
        int n;
        for (n = 0; n < this.text.length() && this.isPunctuation(this.text.charAt(n)); ++n) {
        }
        this.preceding = this.text.substring(0, n);
        this.text = this.text.substring(n, this.text.length());
    }

    private boolean isPunctuation(char c) {
        return c == '.' || c == ',' || c == '!' || c == '?';
    }

    public String getPrecedingPunctuation() {
        return this.preceding;
    }

    public String getTrailingPunctuation() {
        return this.trailing;
    }

    public String getText() {
        return this.text;
    }
}

