/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import games.stendhal.common.ErrorDrain;
import games.stendhal.common.grammar.Grammar;
import games.stendhal.common.parser.CompoundName;
import games.stendhal.common.parser.ConversationContext;
import games.stendhal.common.parser.ConversationParser;
import games.stendhal.common.parser.Expression;
import games.stendhal.common.parser.ExpressionType;
import games.stendhal.common.parser.PunctuationParser;
import games.stendhal.common.parser.Sentence;
import games.stendhal.common.parser.WordEntry;
import games.stendhal.common.parser.WordList;
import java.util.Iterator;

public final class SentenceImplementation
extends Sentence {
    SentenceImplementation(ConversationContext conversationContext, String string) {
        super(conversationContext);
        this.originalText = string;
    }

    public SentenceImplementation(Expression ... expressionArray) {
        super(new ConversationContext());
        for (Expression expression : expressionArray) {
            this.expressions.add(expression);
        }
    }

    void parse(ConversationParser conversationParser) {
        String string;
        Expression expression = null;
        while ((string = conversationParser.readNextWord()) != null) {
            if (string.equals("and")) {
                if (expression == null) continue;
                expression.setBreakFlag();
                continue;
            }
            PunctuationParser punctuationParser = new PunctuationParser(string);
            String string2 = punctuationParser.getPrecedingPunctuation();
            String string3 = punctuationParser.getText();
            if (string2.length() > 0 && string3.matches("[0-9.,]+")) {
                string3 = string;
            }
            if (string2.contains(",") && expression != null) {
                expression.setBreakFlag();
            }
            Expression expression2 = new Expression(string3);
            this.expressions.add(expression2);
            if (punctuationParser.getTrailingPunctuation().contains(",")) {
                expression2.setBreakFlag();
            }
            expression = expression2;
        }
    }

    void classifyWords(ErrorDrain errorDrain) {
        WordList wordList = WordList.getInstance();
        for (Expression expression : this.expressions) {
            Object object;
            String string = expression.getOriginal();
            if (this.context.isForMatching() && ExpressionType.isTypeString(string)) {
                expression.setType(new ExpressionType(string));
                expression.setNormalized("*");
            }
            boolean bl = expression.getType() != null;
            boolean bl2 = false;
            if (!bl) {
                object = wordList.find(string);
                if (object == null) {
                    bl2 = true;
                } else if (((WordEntry)object).getType() != null) {
                    ExpressionType expressionType = ((WordEntry)object).getType();
                    expression.setType(expressionType);
                    bl = true;
                    if (expressionType.isNumeral()) {
                        expression.setAmount(((WordEntry)object).getValue());
                        expression.setNormalized(Integer.toString(expression.getAmount()));
                    } else if (expressionType.isPlural()) {
                        if (((WordEntry)object).getPlurSing() != null) {
                            expression.setNormalized(((WordEntry)object).getPlurSing());
                        } else {
                            expression.setNormalized(string);
                        }
                    } else {
                        expression.setNormalized(((WordEntry)object).getNormalized());
                    }
                }
            }
            if (!bl && string.matches("^[+-]?[0-9.,]+")) {
                expression.parseAmount(string, errorDrain);
                int n = expression.getAmount();
                if (n < 0) {
                    errorDrain.setError("negative amount: " + n);
                }
                boolean bl3 = bl = expression.getType() != null;
            }
            if (!bl && (object = wordList.normalizeVerb(string)) != null) {
                if (((WordList.Verb)object).isGerund) {
                    expression.setType(new ExpressionType(((WordList.Verb)object).entry.getTypeString() + "-GER"));
                    bl = true;
                } else if (((WordList.Verb)object).entry.getType() != null && ((WordList.Verb)object).entry.getType().isVerb()) {
                    expression.setType(((WordList.Verb)object).entry.getType());
                    bl = true;
                } else if (!((WordList.Verb)object).isPast) {
                    expression.setType(new ExpressionType("VER"));
                    bl = true;
                }
                if (bl) {
                    expression.setNormalized(((WordList.Verb)object).entry.getNormalized());
                }
            }
            if (!bl && (object = wordList.normalizeAdjective(string)) != null) {
                expression.setType(new ExpressionType("ADJ"));
                expression.setNormalized(((WordEntry)object).getNormalized());
                bl = true;
            }
            if (!bl) {
                expression.setType(new ExpressionType(""));
                expression.setNormalized(string.toLowerCase());
                if (bl2) {
                    wordList.addNewWord(string);
                }
            }
            assert (expression.getType() != null);
        }
    }

    void standardizeSentenceType() {
        Expression expression;
        Expression expression2 = null;
        Iterator iterator = this.expressions.iterator();
        while (iterator.hasNext() && !(expression = (Expression)iterator.next()).getBreakFlag()) {
            if (expression.getType() == null) continue;
            if (expression.getType().isVerb()) {
                if (expression2 != null) break;
                expression2 = expression;
                continue;
            }
            if (!expression.getType().isSubject()) continue;
            if (!expression.getOriginal().equalsIgnoreCase("me") || expression2 == null) break;
            Expression expression3 = new Expression("you", "SUB");
            this.expressions.add(0, expression3);
            this.sentenceType = Sentence.SentenceType.IMPERATIVE;
            break;
        }
    }

    void performaAliasing() {
        Expression expression = this.getVerb(0);
        Expression expression2 = this.getVerb(1);
        Expression expression3 = this.getSubject(0);
        Expression expression4 = this.getSubject(1);
        if (this.matchesNormalizedStart("will SUB VER")) {
            expression2.mergeLeft(expression, false);
            this.expressions.remove(expression);
            this.sentenceType = Sentence.SentenceType.QUESTION;
        } else if (this.matchesNormalized("you have OBJ for me")) {
            this.expressions.remove(expression3);
            this.expressions.remove(this.getPreposition(0));
            this.expressions.remove(expression4);
            expression.setNormalized("buy");
            this.sentenceType = Sentence.SentenceType.IMPERATIVE;
        } else if (SentenceImplementation.isYouGiveMe(expression3, expression, expression4)) {
            this.expressions.remove(expression3);
            this.expressions.remove(expression4);
            expression.setNormalized("buy");
            this.sentenceType = Sentence.SentenceType.IMPERATIVE;
        }
        if (this.isLikeToHave()) {
            this.getVerb().setNormalized("buy");
            this.sentenceType = Sentence.SentenceType.IMPERATIVE;
        }
    }

    private static boolean isYouGiveMe(Expression expression, Expression expression2, Expression expression3) {
        return expression2 != null && expression != null && expression3 != null && expression.getNormalized().equals("you") && expression2.getNormalized().equals("give") && expression3.getNormalized().equals("i");
    }

    private boolean isLikeToHave() {
        Expression expression = this.getVerb();
        if (expression != null && expression.getNormalized().equals("have") && expression.getOriginal().contains("like")) {
            Expression expression2 = this.getSubject(0);
            Expression expression3 = (Expression)this.expressions.get(0);
            Expression expression4 = (Expression)this.expressions.get(1);
            if (expression2 == null && expression == expression3) {
                return true;
            }
            if (expression2 == expression3 && expression == expression4) {
                return true;
            }
        }
        return false;
    }

    Sentence.SentenceType evaluateSentenceType() {
        Expression expression;
        Iterator<Expression> iterator = this.expressions.iterator();
        Sentence.SentenceType sentenceType = Sentence.SentenceType.UNDEFINED;
        boolean bl = false;
        Expression expression2 = this.nextValid(iterator);
        if (expression2 != null) {
            while (expression2 != null && expression2.isQuestion() && iterator.hasNext()) {
                if (sentenceType == Sentence.SentenceType.UNDEFINED) {
                    sentenceType = Sentence.SentenceType.QUESTION;
                }
                expression2 = this.nextValid(iterator);
            }
            expression = null;
            Expression expression3 = null;
            expression = this.nextValid(iterator);
            expression3 = this.nextValid(iterator);
            if (expression != null) {
                if (expression2.getNormalized().equals("is")) {
                    if (sentenceType == Sentence.SentenceType.UNDEFINED) {
                        sentenceType = Sentence.SentenceType.QUESTION;
                    }
                } else if (expression2.getNormalized().equals("do") && !expression.getOriginal().equalsIgnoreCase("me")) {
                    if (sentenceType == Sentence.SentenceType.UNDEFINED) {
                        sentenceType = Sentence.SentenceType.QUESTION;
                    }
                    if (expression2.isNegated()) {
                        if (this.getVerbCount() > 1) {
                            bl = true;
                            this.expressions.remove(expression2);
                        }
                    } else {
                        this.expressions.remove(expression2);
                    }
                } else if (expression2.getNormalized().equals("it") && expression.getNormalized().equals("is") && expression3 != null && expression3.getType() != null && expression3.getType().isGerund()) {
                    if (sentenceType == Sentence.SentenceType.UNDEFINED) {
                        sentenceType = Sentence.SentenceType.STATEMENT;
                    }
                    this.expressions.remove(expression2);
                    this.expressions.remove(expression);
                }
            }
        }
        if (bl && (expression = this.getVerb(0)) != null) {
            expression.negate();
        }
        if (sentenceType != Sentence.SentenceType.UNDEFINED && this.sentenceType == Sentence.SentenceType.UNDEFINED) {
            this.sentenceType = sentenceType;
        }
        return sentenceType;
    }

    void mergeWords() {
        this.mergeCompoundNames();
        this.mergeThreeWordExpressions();
        if (this.mergeTwoWordExpressions() > 0) {
            this.mergeThreeWordExpressions();
        }
    }

    public int mergeCompoundNames() {
        boolean bl;
        WordList wordList = WordList.getInstance();
        int n = 0;
        block0: do {
            bl = false;
            for (int i = 0; i < this.expressions.size() - 1; ++i) {
                CompoundName compoundName = wordList.searchCompoundName(this.expressions, i);
                if (compoundName != null) {
                    Expression expression = (Expression)this.expressions.get(i);
                    int n2 = compoundName.size();
                    for (int j = 1; j < n2; ++j) {
                        Expression expression2 = (Expression)this.expressions.get(i + 1);
                        expression.mergeName(expression2, compoundName.getType());
                        this.expressions.remove(expression2);
                    }
                    bl = true;
                    continue block0;
                }
                if (!bl) continue;
                ++n;
                continue block0;
            }
        } while (bl);
        return n;
    }

    private int mergeTwoWordExpressions() {
        boolean bl;
        int n = 0;
        do {
            bl = false;
            Iterator iterator = this.expressions.iterator();
            boolean bl2 = false;
            boolean bl3 = false;
            if (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                while (iterator.hasNext()) {
                    Expression expression2 = expression;
                    expression = (Expression)iterator.next();
                    if (expression2.getBreakFlag() || this.context.isForMatching() && (expression2.getNormalized().contains("*") || expression.getNormalized().contains("*"))) continue;
                    ExpressionType expressionType = expression2.getType();
                    ExpressionType expressionType2 = expression.getType();
                    if (expressionType != null && expressionType.isConditional()) {
                        bl2 = true;
                    }
                    if (expressionType != null && expressionType2 != null) {
                        if (SentenceImplementation.isCompoundNoun(expressionType, expressionType2, bl3)) {
                            if (Grammar.mergeCompoundNoun(expression2, expression) == expression2) {
                                this.expressions.remove(expression);
                            } else {
                                this.expressions.remove(expression2);
                            }
                            bl = true;
                            break;
                        }
                        if (expressionType.isNumeral() && (expressionType2.isObject() || expressionType2.isSubject())) {
                            expression.mergeLeft(expression2, false);
                            this.expressions.remove(expression2);
                            bl = true;
                            break;
                        }
                        if (expressionType.isVerb() && expressionType2.isVerb()) {
                            if (expression2.getNormalized().equals("do")) {
                                expression.mergeSimple(expression2);
                                this.expressions.remove(expression2);
                                bl = true;
                                break;
                            }
                            if (bl2) {
                                expression.mergeLeft(expression2, false);
                                this.expressions.remove(expression2);
                                bl = true;
                                break;
                            }
                        } else {
                            if (expressionType.getMainType().equals(expressionType2.getMainType())) {
                                expression2.mergeRight(expression, true);
                                this.expressions.remove(expression);
                                bl = true;
                                break;
                            }
                            if (expressionType.isQuestion() && (expressionType2.isVerb() || expressionType2.isAdjective())) {
                                expression.mergeLeft(expression2, false);
                                this.expressions.remove(expression2);
                                bl = true;
                                break;
                            }
                        }
                    }
                    if (this.context.getIgnoreIgnorable() && expressionType != null && this.isIgnorable(expression2)) {
                        expression.mergeLeft(expression2, false);
                        this.expressions.remove(expression2);
                        bl = true;
                        break;
                    }
                    if (expression2.getBreakFlag()) {
                        bl3 = false;
                        continue;
                    }
                    if (expressionType == null) continue;
                    if (expressionType.isVerb()) {
                        bl3 = true;
                        continue;
                    }
                    if (!expressionType.isSubject()) continue;
                    bl3 = false;
                }
            }
            if (!bl) continue;
            ++n;
        } while (bl);
        return n;
    }

    private static boolean isCompoundNoun(ExpressionType expressionType, ExpressionType expressionType2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = expressionType2.isObject() || expressionType2.isSubject() && !expressionType2.isPronoun();
        if (bl2) {
            boolean bl4;
            boolean bl5 = bl4 = expressionType.isObject() || expressionType.isSubject() && !expressionType.isPronoun() && !expressionType.isName();
            if (bl4) {
                return true;
            }
            if (expressionType.isAdjective()) {
                return true;
            }
            if (expressionType.isVerb() && bl) {
                return true;
            }
        }
        return false;
    }

    private int mergeThreeWordExpressions() {
        boolean bl;
        int n = 0;
        do {
            Iterator iterator = this.expressions.iterator();
            bl = false;
            if (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (iterator.hasNext()) {
                    Expression expression2 = null;
                    Expression expression3 = expression;
                    expression = (Expression)iterator.next();
                    while (iterator.hasNext()) {
                        String string;
                        expression2 = expression3;
                        expression3 = expression;
                        expression = (Expression)iterator.next();
                        if (expression2.getBreakFlag() || expression3.getBreakFlag() || this.context.isForMatching() && (expression2.getNormalized().contains("*") || expression3.getNormalized().contains("*") || expression.getNormalized().contains("*")) || !expression2.isObject() || !expression3.getNormalized().equals("of") || !expression.isObject() || Grammar.isNormalized(string = expression2.getNormalized() + " of " + expression.getNormalized())) continue;
                        expression2.mergeRight(expression3, false);
                        this.expressions.remove(expression3);
                        expression.mergeLeft(expression2, false);
                        this.expressions.remove(expression2);
                        bl = true;
                        break;
                    }
                }
            }
            if (!bl) continue;
            ++n;
        } while (bl);
        return n;
    }
}

