/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.tiled;

import games.stendhal.common.tiled.StendhalMapStructure;
import games.stendhal.common.tiled.TileSetDefinition;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.Serializable;

public class LayerDefinition
implements Serializable {
    private StendhalMapStructure map = null;
    private int width;
    private int height;
    private String name;
    private int[] data = null;
    private byte[] raw;

    public LayerDefinition(int n, int n2) {
        this.raw = new byte[4 * n * n2];
        this.data = new int[n * n2];
        this.width = n;
        this.height = n2;
    }

    public void setMap(StendhalMapStructure stendhalMapStructure) {
        this.map = stendhalMapStructure;
    }

    public void build() {
        this.data = new int[this.height * this.width];
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n2 = 0;
                n2 |= this.raw[0 + n] & 0xFF;
                n2 |= (this.raw[1 + n] & 0xFF) << 8;
                n2 |= (this.raw[2 + n] & 0xFF) << 16;
                this.data[j + i * this.width] = n2 |= (this.raw[3 + n] & 0xFF) << 24;
                n += 4;
            }
        }
    }

    public byte[] exposeRaw() {
        return this.raw;
    }

    public int[] expose() {
        return this.data;
    }

    public void set(int n, int n2, int n3) {
        int n4 = 4 * (n + n2 * this.width);
        this.raw[0 + n4] = (byte)(n3 & 0xFF);
        this.raw[1 + n4] = (byte)(n3 >>> 8 & 0xFF);
        this.raw[2 + n4] = (byte)(n3 >>> 16 & 0xFF);
        this.raw[3 + n4] = (byte)(n3 >>> 24 & 0xFF);
        this.data[n2 * this.width + n] = n3;
    }

    public int getTileAt(int n, int n2) {
        return this.data[n2 * this.width + n];
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        OutputSerializer outputSerializer = new OutputSerializer((OutputStream)deflaterOutputStream);
        this.writeObject(outputSerializer);
        deflaterOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static LayerDefinition decode(InputStream inputStream) throws IOException, ClassNotFoundException {
        LayerDefinition layerDefinition = new LayerDefinition(0, 0);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(inputStream, new Inflater());
        InputSerializer inputSerializer = new InputSerializer((InputStream)inflaterInputStream);
        layerDefinition = (LayerDefinition)inputSerializer.readObject((Serializable)layerDefinition);
        layerDefinition.build();
        return layerDefinition;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public TileSetDefinition getTilesetFor(int n) {
        if (n == 0) {
            return null;
        }
        List<TileSetDefinition> list = this.map.getTilesets();
        int n2 = 0;
        for (n2 = 0; n2 < list.size() && n >= list.get(n2).getFirstGid(); ++n2) {
        }
        return list.get(n2 - 1);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void readObject(InputSerializer inputSerializer) throws IOException {
        this.name = inputSerializer.readString();
        this.width = inputSerializer.readInt();
        this.height = inputSerializer.readInt();
        this.raw = inputSerializer.readByteArray();
    }

    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        outputSerializer.write(this.name);
        outputSerializer.write(this.width);
        outputSerializer.write(this.height);
        outputSerializer.write(this.raw);
    }
}

