/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.net.DefaultEvaluator;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.spi.TriggeringEventEvaluator;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public class SMTPAppender
extends AppenderSkeleton
implements UnrecognizedElementHandler {
    private String to;
    private String cc;
    private String bcc;
    private String from;
    private String replyTo;
    private String subject;
    private String smtpHost;
    private String smtpUsername;
    private String smtpPassword;
    private String smtpProtocol;
    private int smtpPort = -1;
    private boolean smtpDebug = false;
    private int bufferSize = 512;
    private boolean locationInfo = false;
    private boolean sendOnClose = false;
    protected CyclicBuffer cb = new CyclicBuffer(this.bufferSize);
    protected Message msg;
    protected TriggeringEventEvaluator evaluator;

    public SMTPAppender() {
        this(new DefaultEvaluator());
    }

    public SMTPAppender(TriggeringEventEvaluator triggeringEventEvaluator) {
        this.evaluator = triggeringEventEvaluator;
    }

    @Override
    public void activateOptions() {
        Session session = this.createSession();
        this.msg = new MimeMessage(session);
        try {
            this.addressMessage(this.msg);
            if (this.subject != null) {
                try {
                    this.msg.setSubject(MimeUtility.encodeText((String)this.subject, (String)"UTF-8", null));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LogLog.error("Unable to encode SMTP subject", unsupportedEncodingException);
                }
            }
        }
        catch (MessagingException messagingException) {
            LogLog.error("Could not activate SMTPAppender options.", messagingException);
        }
        if (this.evaluator instanceof OptionHandler) {
            ((OptionHandler)((Object)this.evaluator)).activateOptions();
        }
    }

    protected void addressMessage(Message message) throws MessagingException {
        if (this.from != null) {
            message.setFrom((Address)this.getAddress(this.from));
        } else {
            message.setFrom();
        }
        if (this.replyTo != null && this.replyTo.length() > 0) {
            message.setReplyTo((Address[])this.parseAddress(this.replyTo));
        }
        if (this.to != null && this.to.length() > 0) {
            message.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(this.to));
        }
        if (this.cc != null && this.cc.length() > 0) {
            message.setRecipients(Message.RecipientType.CC, (Address[])this.parseAddress(this.cc));
        }
        if (this.bcc != null && this.bcc.length() > 0) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])this.parseAddress(this.bcc));
        }
    }

    protected Session createSession() {
        Properties properties = null;
        try {
            properties = new Properties(System.getProperties());
        }
        catch (SecurityException securityException) {
            properties = new Properties();
        }
        String string = "mail.smtp";
        if (this.smtpProtocol != null) {
            properties.put("mail.transport.protocol", this.smtpProtocol);
            string = "mail." + this.smtpProtocol;
        }
        if (this.smtpHost != null) {
            properties.put(string + ".host", this.smtpHost);
        }
        if (this.smtpPort > 0) {
            properties.put(string + ".port", String.valueOf(this.smtpPort));
        }
        Authenticator authenticator = null;
        if (this.smtpPassword != null && this.smtpUsername != null) {
            properties.put(string + ".auth", "true");
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SMTPAppender.this.smtpUsername, SMTPAppender.this.smtpPassword);
                }
            };
        }
        Session session = Session.getInstance((Properties)properties, authenticator);
        if (this.smtpProtocol != null) {
            session.setProtocolForAddress("rfc822", this.smtpProtocol);
        }
        if (this.smtpDebug) {
            session.setDebug(this.smtpDebug);
        }
        return session;
    }

    @Override
    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        loggingEvent.getThreadName();
        loggingEvent.getNDC();
        loggingEvent.getMDCCopy();
        if (this.locationInfo) {
            loggingEvent.getLocationInformation();
        }
        loggingEvent.getRenderedMessage();
        loggingEvent.getThrowableStrRep();
        this.cb.add(loggingEvent);
        if (this.evaluator.isTriggeringEvent(loggingEvent)) {
            this.sendBuffer();
        }
    }

    protected boolean checkEntryConditions() {
        if (this.msg == null) {
            this.errorHandler.error("Message object not configured.");
            return false;
        }
        if (this.evaluator == null) {
            this.errorHandler.error("No TriggeringEventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        if (this.sendOnClose && this.cb.length() > 0) {
            this.sendBuffer();
        }
    }

    InternetAddress getAddress(String string) {
        try {
            return new InternetAddress(string);
        }
        catch (AddressException addressException) {
            this.errorHandler.error("Could not parse address [" + string + "].", (Exception)((Object)addressException), 6);
            return null;
        }
    }

    InternetAddress[] parseAddress(String string) {
        try {
            return InternetAddress.parse((String)string, (boolean)true);
        }
        catch (AddressException addressException) {
            this.errorHandler.error("Could not parse address [" + string + "].", (Exception)((Object)addressException), 6);
            return null;
        }
    }

    public String getTo() {
        return this.to;
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    protected String formatBody() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.layout.getHeader();
        if (string != null) {
            stringBuffer.append(string);
        }
        int n = this.cb.length();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            LoggingEvent loggingEvent = this.cb.get();
            stringBuffer.append(this.layout.format(loggingEvent));
            if (!this.layout.ignoresThrowable() || (stringArray = loggingEvent.getThrowableStrRep()) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                stringBuffer.append(stringArray[j]);
                stringBuffer.append(Layout.LINE_SEP);
            }
        }
        string = this.layout.getFooter();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected void sendBuffer() {
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            MimeBodyPart mimeBodyPart;
            String string = this.formatBody();
            boolean bl = true;
            for (int i = 0; i < string.length() && bl; ++i) {
                bl = string.charAt(i) <= '\u007f';
            }
            if (bl) {
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setContent((Object)string, this.layout.getContentType());
            } else {
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(MimeUtility.encode((OutputStream)byteArrayOutputStream, (String)"quoted-printable"), "UTF-8");
                    outputStreamWriter.write(string);
                    ((Writer)outputStreamWriter).close();
                    InternetHeaders internetHeaders = new InternetHeaders();
                    internetHeaders.setHeader("Content-Type", this.layout.getContentType() + "; charset=UTF-8");
                    internetHeaders.setHeader("Content-Transfer-Encoding", "quoted-printable");
                    mimeBodyPart = new MimeBodyPart(internetHeaders, byteArrayOutputStream.toByteArray());
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    for (int i = 0; i < stringBuffer.length(); ++i) {
                        if (stringBuffer.charAt(i) < '\u0080') continue;
                        stringBuffer.setCharAt(i, '?');
                    }
                    mimeBodyPart = new MimeBodyPart();
                    mimeBodyPart.setContent((Object)stringBuffer.toString(), this.layout.getContentType());
                }
            }
            byteArrayOutputStream = new MimeMultipart();
            byteArrayOutputStream.addBodyPart((BodyPart)mimeBodyPart);
            this.msg.setContent((Multipart)byteArrayOutputStream);
            this.msg.setSentDate(new Date());
            Transport.send((Message)this.msg);
        }
        catch (MessagingException messagingException) {
            LogLog.error("Error occured while sending e-mail notification.", messagingException);
        }
        catch (RuntimeException runtimeException) {
            LogLog.error("Error occured while sending e-mail notification.", runtimeException);
        }
    }

    public String getEvaluatorClass() {
        return this.evaluator == null ? null : this.evaluator.getClass().getName();
    }

    public String getFrom() {
        return this.from;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setReplyTo(String string) {
        this.replyTo = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
        this.cb.resize(n);
    }

    public void setSMTPHost(String string) {
        this.smtpHost = string;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void setTo(String string) {
        this.to = string;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setEvaluatorClass(String string) {
        this.evaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName(string, TriggeringEventEvaluator.class, this.evaluator);
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setCc(String string) {
        this.cc = string;
    }

    public String getCc() {
        return this.cc;
    }

    public void setBcc(String string) {
        this.bcc = string;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setSMTPPassword(String string) {
        this.smtpPassword = string;
    }

    public void setSMTPUsername(String string) {
        this.smtpUsername = string;
    }

    public void setSMTPDebug(boolean bl) {
        this.smtpDebug = bl;
    }

    public String getSMTPPassword() {
        return this.smtpPassword;
    }

    public String getSMTPUsername() {
        return this.smtpUsername;
    }

    public boolean getSMTPDebug() {
        return this.smtpDebug;
    }

    public final void setEvaluator(TriggeringEventEvaluator triggeringEventEvaluator) {
        if (triggeringEventEvaluator == null) {
            throw new NullPointerException("trigger");
        }
        this.evaluator = triggeringEventEvaluator;
    }

    public final TriggeringEventEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public boolean parseUnrecognizedElement(Element element, Properties properties) throws Exception {
        if ("triggeringPolicy".equals(element.getNodeName())) {
            Object object = DOMConfigurator.parseElement(element, properties, TriggeringEventEvaluator.class);
            if (object instanceof TriggeringEventEvaluator) {
                this.setEvaluator((TriggeringEventEvaluator)object);
            }
            return true;
        }
        return false;
    }

    public final String getSMTPProtocol() {
        return this.smtpProtocol;
    }

    public final void setSMTPProtocol(String string) {
        this.smtpProtocol = string;
    }

    public final int getSMTPPort() {
        return this.smtpPort;
    }

    public final void setSMTPPort(int n) {
        this.smtpPort = n;
    }

    public final boolean getSendOnClose() {
        return this.sendOnClose;
    }

    public final void setSendOnClose(boolean bl) {
        this.sendOnClose = bl;
    }
}

